/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean c;
    @Nullable
    private final DebuggerSession f;
    private final SuspendContextImpl b;
    private final ThreadReferenceProxyImpl e;
    private StackFrameProxyImpl a;
    private SourcePosition h;
    private PsiElement d;

    private DebuggerContextImpl(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl, SourcePosition sourcePosition, PsiElement psiElement, boolean bl2) {
        g.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        this.f = debuggerSession;
        this.e = threadReferenceProxyImpl;
        this.a = stackFrameProxyImpl;
        this.h = sourcePosition;
        this.b = suspendContextImpl;
        this.d = psiElement;
        this.c = bl2;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.f;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.f != null ? this.f.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.e;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.b;
    }

    public Project getProject() {
        return this.f != null ? this.f.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        g.assertTrue(this.c);
        return this.a;
    }

    public SourcePosition getSourcePosition() {
        g.assertTrue(this.c);
        return this.h;
    }

    public PsiElement getContextElement() {
        g.assertTrue(this.c);
        PsiElement psiElement = this.d;
        if (psiElement != null && !psiElement.isValid()) {
            this.d = ContextUtil.getContextElement(this.h);
        }
        return this.d;
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl suspendContextImpl = this.getSuspendContext();
        return suspendContextImpl != null ? new EvaluationContextImpl(suspendContextImpl, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        g.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(debuggerSession, suspendContextImpl, threadReferenceProxyImpl, stackFrameProxyImpl, null, null, suspendContextImpl == null);
        if (debuggerContextImpl == null) {
            DebuggerContextImpl.a(0);
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.c) {
            return;
        }
        this.c = true;
        if (this.a == null && this.e != null) {
            try {
                this.a = this.e.frameCount() > 0 ? this.e.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.a != null) {
            if (this.h == null) {
                this.h = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.d = ContextUtil.getContextElement(this.h);
        }
    }

    public void setPositionCache(SourcePosition sourcePosition) {
        this.h = sourcePosition;
    }

    public boolean isInitialised() {
        return this.c;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess();
        return debugProcessImpl != null && debugProcessImpl.getSuspendManager().getPausedContext() != null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
    }
}

