/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    public static void setStackFrame(final DebuggerStateManager debuggerStateManager, final StackFrameProxyImpl stackFrameProxyImpl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl debuggerContextImpl = debuggerStateManager.getContext();
        final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null) {
            debuggerSession.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContextImpl = SuspendManagerUtil.findContextByThread(debuggerSession.getProcess().getSuspendManager(), stackFrameProxyImpl.threadProxy());
                    DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, suspendContextImpl, stackFrameProxyImpl.threadProxy(), stackFrameProxyImpl);
                    DebuggerInvocationUtil.swingInvokeLater(debuggerSession.getProject(), () -> {
                        debuggerStateManager.setState(debuggerContextImpl, debuggerSession.getState(), DebuggerSession.Event.REFRESH, null);
                        SourceCodeChecker.checkSource(debuggerContextImpl);
                    });
                }
            });
        } else {
            debuggerStateManager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.REFRESH, null);
        }
    }

    public static void setThread(DebuggerStateManager debuggerStateManager, ThreadDescriptorImpl threadDescriptorImpl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerSession debuggerSession = debuggerStateManager.getContext().getDebuggerSession();
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, threadDescriptorImpl.getSuspendContext(), threadDescriptorImpl.getThreadReference(), null);
        debuggerStateManager.setState(debuggerContextImpl, debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession debuggerSession, SuspendContextImpl suspendContextImpl) {
        if (debuggerSession == null) {
            DebuggerContextUtil.a(0);
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, suspendContextImpl, suspendContextImpl != null ? suspendContextImpl.getThread() : null, null);
        if (debuggerContextImpl == null) {
            DebuggerContextUtil.a(1);
        }
        return debuggerContextImpl;
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl debuggerContextImpl, @NotNull PsiElement psiElement, @NotNull PsiFile psiFile) {
        if (debuggerContextImpl == null) {
            DebuggerContextUtil.a(2);
        }
        if (psiElement == null) {
            DebuggerContextUtil.a(3);
        }
        if (psiFile == null) {
            DebuggerContextUtil.a(4);
        }
        if (psiElement instanceof PsiCompiledElement) {
            return null;
        }
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null) {
            try {
                XDebugSession xDebugSession = debuggerSession.getXDebugSession();
                if (xDebugSession != null) {
                    XSourcePosition xSourcePosition = xDebugSession.getCurrentPosition();
                    Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)psiFile.getProject())).getSelectedTextEditor(true);
                    if (editor != null && xSourcePosition != null && xSourcePosition.getFile().equals(psiFile.getOriginalFile().getVirtualFile())) {
                        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)debuggerContextImpl), PsiMethod.class, (boolean)false);
                        Collection collection = IdentifierHighlighterPass.getUsages((PsiElement)psiElement, (PsiElement)(psiMethod != null ? psiMethod : psiFile), (boolean)false);
                        int n2 = xSourcePosition.getLine();
                        int n3 = -1;
                        int n4 = -1;
                        for (TextRange textRange : collection) {
                            int n5 = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
                            if (n5 > n3 && n5 < n2) {
                                n3 = n5;
                                n4 = textRange.getStartOffset();
                                continue;
                            }
                            if (n5 != n2) continue;
                            n4 = textRange.getStartOffset();
                            break;
                        }
                        if (n4 > -1) {
                            return SourcePosition.createFromOffset((PsiFile)psiFile, (int)n4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebuggerContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDebuggerContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNearest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

