/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.InvokeThread");
    private static final ThreadLocal<WorkerThreadRequest> b = new ThreadLocal();
    protected final Project myProject;
    protected final EventQueue<E> myEvents;
    private volatile WorkerThreadRequest c = null;

    public InvokeThread(Project project2) {
        this.myProject = project2;
        this.myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(E var1);

    protected void startNewWorkerThread() {
        WorkerThreadRequest workerThreadRequest;
        this.c = workerThreadRequest = new WorkerThreadRequest(this);
        workerThreadRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerThreadRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(@NotNull WorkerThreadRequest workerThreadRequest) {
        block21: {
            if (workerThreadRequest == null) {
                InvokeThread.a(0);
            }
            String string = Thread.currentThread().getName();
            Thread.currentThread().setName("DebuggerManagerThread");
            try {
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                while (true) {
                    try {
                        while (true) {
                            if (workerThreadRequest.isStopRequested()) {
                                break block21;
                            }
                            WorkerThreadRequest workerThreadRequest2 = this.getCurrentRequest();
                            if (workerThreadRequest2 != workerThreadRequest) {
                                a.error("Expected " + workerThreadRequest + " instead of " + workerThreadRequest2);
                                if (workerThreadRequest2 != null && !workerThreadRequest2.isDone()) continue;
                            }
                            this.processEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (EventQueueClosedException eventQueueClosedException) {
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getCause() instanceof InterruptedException) {
                            break;
                        }
                        a.error((Throwable)runtimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        a.error(throwable);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (workerThreadRequest == this.getCurrentRequest()) {
                    for (PrioritizedTask prioritizedTask : this.myEvents.clearQueue()) {
                        try {
                            this.processEvent(prioritizedTask);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                a.debug("Request " + this.toString() + " exited");
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
                Thread.currentThread().setName(string);
            }
        }
    }

    protected static InvokeThread currentThread() {
        WorkerThreadRequest workerThreadRequest = InvokeThread.getCurrentThreadRequest();
        return workerThreadRequest != null ? workerThreadRequest.getOwner() : null;
    }

    public boolean schedule(@Debugger.Capture E e2) {
        if (a.isDebugEnabled()) {
            a.debug("schedule " + e2 + " in " + this);
        }
        return this.myEvents.put(e2, e2.getPriority().ordinal());
    }

    public boolean pushBack(E e2) {
        if (a.isDebugEnabled()) {
            a.debug("pushBack " + e2 + " in " + this);
        }
        return this.myEvents.pushBack(e2, e2.getPriority().ordinal());
    }

    protected void switchToRequest(WorkerThreadRequest workerThreadRequest) {
        WorkerThreadRequest workerThreadRequest2 = InvokeThread.getCurrentThreadRequest();
        a.assertTrue(workerThreadRequest2 != null);
        this.c = workerThreadRequest;
        if (a.isDebugEnabled()) {
            a.debug("Closing " + workerThreadRequest2 + " new request = " + workerThreadRequest);
        }
        workerThreadRequest2.requestStop();
    }

    public WorkerThreadRequest getCurrentRequest() {
        return this.c;
    }

    public static WorkerThreadRequest getCurrentThreadRequest() {
        return b.get();
    }

    public void close() {
        this.myEvents.close();
        a.debug("Closing evaluation");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadRequest", "com/intellij/debugger/impl/InvokeThread", "run"));
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> b;
        private volatile Future<?> a;
        private volatile boolean c = false;

        WorkerThreadRequest(InvokeThread<E> invokeThread) {
            this.b = invokeThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                while (this.a == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            b.set(this);
            try {
                ((InvokeThread)this.b).a(this);
            }
            finally {
                b.set(null);
                boolean bl2 = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future = this.a;
            assert (future != null);
            this.c = true;
            future.cancel(true);
        }

        public boolean isStopRequested() {
            Future<?> future = this.a;
            assert (future != null);
            return this.c || future.isCancelled() || future.isDone();
        }

        public void join() throws InterruptedException, ExecutionException {
            assert (this.a != null);
            try {
                this.a.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        public void join(long l2) throws InterruptedException, ExecutionException {
            assert (this.a != null);
            try {
                this.a.get(l2, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRequestFuture(Future<?> future) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.a = future;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.b;
        }

        public boolean isDone() {
            assert (this.a != null);
            return this.a.isDone() && b.get() == null;
        }
    }
}

