/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;

public class LocalVariableProxyImpl
extends JdiProxy
implements LocalVariableProxy {
    private final StackFrameProxyImpl d;
    private final String c;
    private final String e;
    private LocalVariable b;
    private Type f;

    public LocalVariableProxyImpl(StackFrameProxyImpl stackFrameProxyImpl, LocalVariable localVariable) {
        super(stackFrameProxyImpl.myTimer);
        this.d = stackFrameProxyImpl;
        this.c = localVariable.name();
        this.e = localVariable.typeName();
        this.b = localVariable;
    }

    @Override
    protected void clearCaches() {
        this.b = null;
        this.f = null;
    }

    public LocalVariable getVariable() throws EvaluateException {
        this.checkValid();
        if (this.b == null) {
            this.b = this.d.visibleVariableByNameInt(this.c);
            if (this.b == null) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
        }
        return this.b;
    }

    public Type getType() throws EvaluateException, ClassNotLoadedException {
        if (this.f == null) {
            this.f = this.getVariable().type();
        }
        return this.f;
    }

    public StackFrameProxyImpl getFrame() {
        return this.d;
    }

    public int hashCode() {
        return 31 * this.d.hashCode() + this.c.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LocalVariableProxyImpl) {
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)object;
            return Comparing.equal((Object)localVariableProxyImpl.d, (Object)this.d) && this.c.equals(localVariableProxyImpl.c);
        }
        return false;
    }

    public String name() {
        return this.c;
    }

    public String typeName() {
        return this.e;
    }

    public String toString() {
        return this.c;
    }
}

