/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger k = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadReferenceProxyImpl");
    private String h;
    private int j = -1;
    private final LinkedList<StackFrameProxyImpl> g = new LinkedList();
    private List<StackFrameProxyImpl> i = null;
    private ThreadGroupReferenceProxyImpl l;
    private ThreeState f = ThreeState.UNSURE;
    public static final Comparator<ThreadReferenceProxyImpl> ourComparator = (threadReferenceProxyImpl, threadReferenceProxyImpl2) -> {
        int n2 = Comparing.compare((boolean)threadReferenceProxyImpl2.isSuspended(), (boolean)threadReferenceProxyImpl.isSuspended());
        if (n2 == 0) {
            return threadReferenceProxyImpl.name().compareToIgnoreCase(threadReferenceProxyImpl2.name());
        }
        return n2;
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxyImpl, ThreadReference threadReference) {
        super(virtualMachineProxyImpl, threadReference);
    }

    public ThreadReference getThreadReference() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (ThreadReference)this.getObjectReference();
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            ThreadReferenceProxyImpl.c(0);
        }
        return virtualMachineProxyImpl;
    }

    public String name() {
        this.checkValid();
        if (this.h == null) {
            try {
                this.h = this.getThreadReference().name();
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.h = "";
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.h = "zombie";
            }
        }
        return this.h;
    }

    public int getSuspendCount() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return 0;
        }
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().suspend();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
    }

    @Override
    @NonNls
    public String toString() {
        try {
            return this.name() + ": " + DebuggerUtilsEx.getThreadStatusText(this.status());
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "[thread collected]";
        }
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        if (k.isDebugEnabled()) {
            k.debug("before resume" + threadReference);
        }
        this.getVirtualMachineProxy().clearCaches();
        try {
            threadReference.resume();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.h = null;
        this.i = null;
        this.j = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException | IllegalThreadStateException runtimeException) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.l == null) {
            ThreadGroupReference threadGroupReference;
            try {
                threadGroupReference = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException objectCollectedException) {
                threadGroupReference = null;
            }
            this.l = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupReference);
        }
        return this.l;
    }

    public int frameCount() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.j == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.j = threadReference.frameCount();
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.j = 0;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                boolean bl2;
                try {
                    bl2 = threadReference.isSuspended();
                }
                catch (Throwable throwable) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
                }
                if (!bl2) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
                }
                this.j = 0;
            }
            catch (InternalException internalException) {
                k.info((Throwable)internalException);
                this.j = 0;
            }
        }
        return this.j;
    }

    @NotNull
    public List<StackFrameProxyImpl> forceFrames() throws EvaluateException {
        block7: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.checkValid();
                if (this.i != null) break block7;
                try {
                    List<StackFrame> list2 = threadReference.frames();
                    this.j = list2.size();
                    this.i = new ArrayList<StackFrameProxyImpl>(this.j);
                    this.g.clear();
                    int n2 = 0;
                    for (StackFrame stackFrame : list2) {
                        StackFrameProxyImpl stackFrameProxyImpl = new StackFrameProxyImpl(this, stackFrame, this.j - n2);
                        this.i.add(stackFrameProxyImpl);
                        this.g.addFirst(stackFrameProxyImpl);
                        ++n2;
                    }
                }
                catch (IncompatibleThreadStateException | InternalException exception) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                List<StackFrameProxyImpl> list3 = Collections.emptyList();
                if (list3 == null) {
                    ThreadReferenceProxyImpl.c(1);
                }
                return list3;
            }
        }
        List<StackFrameProxyImpl> list4 = this.i;
        if (list4 == null) {
            ThreadReferenceProxyImpl.c(2);
        }
        return list4;
    }

    @NotNull
    public List<StackFrameProxyImpl> frames() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            this.checkValid();
            if (this.i == null) {
                this.a(threadReference);
                this.i = ContainerUtil.reverse(new ArrayList(this.g.subList(0, this.frameCount())));
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            List<StackFrameProxyImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                ThreadReferenceProxyImpl.c(3);
            }
            return list2;
        }
        List<StackFrameProxyImpl> list3 = this.i;
        if (list3 == null) {
            ThreadReferenceProxyImpl.c(4);
        }
        return list3;
    }

    private void a(@NotNull ThreadReference threadReference) throws EvaluateException {
        if (threadReference == null) {
            ThreadReferenceProxyImpl.c(5);
        }
        int n2 = this.frameCount();
        if (this.g.size() < n2) {
            List<StackFrame> list2;
            try {
                list2 = threadReference.frames(0, n2 - this.g.size());
            }
            catch (IncompatibleThreadStateException | InternalException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            int n3 = this.g.size() + 1;
            ListIterator<StackFrame> listIterator = list2.listIterator(n2 - this.g.size());
            while (listIterator.hasPrevious()) {
                this.g.add(new StackFrameProxyImpl(this, listIterator.previous(), n3));
                ++n3;
            }
        } else {
            while (this.g.size() > n2) {
                this.g.removeLast();
            }
        }
    }

    public StackFrameProxyImpl frame(int n2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
            this.a(threadReference);
            int n3 = this.frameCount();
            if (n3 == 0) {
                return null;
            }
            return this.g.get(n3 - n2 - 1);
        }
        catch (ObjectCollectedException | IllegalThreadStateException runtimeException) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrameProxyImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().popFrames(stackFrameProxyImpl.getStackFrame());
        }
        catch (InvalidStackFrameException | ObjectCollectedException runtimeException) {
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() == 32) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"drop.frame.error.no.information", (Object[])new Object[0]));
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)internalException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void forceEarlyReturn(Value value) throws ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().forceEarlyReturn(value);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void stop(ObjectReference objectReference) throws InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().stop(objectReference);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            k.info((Throwable)illegalThreadStateException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getThreadReference().isAtBreakpoint();
        }
        catch (InternalException internalException) {
            k.info((Throwable)internalException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isResumeOnHotSwap() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.f == ThreeState.UNSURE) {
            this.f = ThreeState.fromBoolean((boolean)this.name().startsWith("YJPAgent-"));
        }
        return this.f.toBoolean();
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadRef";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forceFrames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "frames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/ThreadReferenceProxyImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

