/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.Patches;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.TargetVM;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger C = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    private final DebugProcessImpl F;
    private final VirtualMachine y;
    private int t;
    private int n;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> b;
    private final Map<String, StringReference> a;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> v;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> u;
    private boolean D;
    private List<ReferenceType> w;
    private Map<ReferenceType, List<ReferenceType>> B;
    public final Throwable mySuspendLogger;
    private final boolean l;
    private final boolean d;
    private final Capability f;
    private final Capability m;
    private final Capability r;
    private final Capability g;
    private final Capability p;
    private final Capability h;
    private final Capability q;
    private final Capability s;
    private final Capability i;
    private final Capability o;
    private final Capability c;
    private final Capability j;
    private final Capability A;
    private final Capability G;
    private final Capability e;
    private final Capability z;
    private final Capability E;
    private final Capability k;
    private final Capability x;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcessImpl, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(0);
        }
        this.t = 0;
        this.n = 0;
        this.b = new HashMap<ObjectReference, ObjectReferenceProxyImpl>();
        this.a = new HashMap<String, StringReference>();
        this.v = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.u = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
        this.D = true;
        this.B = new HashMap<ReferenceType, List<ReferenceType>>();
        this.mySuspendLogger = new Throwable();
        this.f = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canWatchFieldModification();
            }
        };
        this.m = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canWatchFieldAccess();
            }
        };
        this.r = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.g = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetBytecodes();
            }
        };
        this.p = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetSyntheticAttribute();
            }
        };
        this.h = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetOwnedMonitorInfo();
            }
        };
        this.q = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetMonitorFrameInfo();
            }
        };
        this.s = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetCurrentContendedMonitor();
            }
        };
        this.i = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canGetMonitorInfo();
            }
        };
        this.o = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canUseInstanceFilters();
            }
        };
        this.c = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canRedefineClasses();
            }
        };
        this.j = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canAddMethod();
            }
        };
        this.A = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canUnrestrictedlyRedefineClasses();
            }
        };
        this.G = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canPopFrames();
            }
        };
        this.e = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.y.canForceEarlyReturn();
            }
        };
        this.z = new Capability(){

            @Override
            protected boolean calcValue() {
                if (!VirtualMachineProxyImpl.this.l) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.y, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    C.error((Throwable)reflectiveOperationException);
                }
                return false;
            }
        };
        this.E = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canGetSourceDebugExtension();
            }
        };
        this.k = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.d && VirtualMachineProxyImpl.this.y.canRequestVMDeathEvent();
            }
        };
        this.x = new Capability(){

            @Override
            protected boolean calcValue() {
                if (VirtualMachineProxyImpl.this.l) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean bl2 = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.y, new Object[0]);
                        return bl2;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.y = virtualMachine;
        this.F = debugProcessImpl;
        this.l = this.versionHigher("1.5");
        this.d = this.l || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        try {
            virtualMachine.allClasses();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw vMDisconnectedException;
        }
        catch (Throwable throwable) {
            C.info(throwable);
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.y;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(1);
        }
        return virtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    public List<ReferenceType> classesByName(@NotNull String string) {
        if (string == null) {
            VirtualMachineProxyImpl.a(2);
        }
        return this.y.classesByName(string);
    }

    public List<ReferenceType> nestedTypes(ReferenceType referenceType) {
        List<Object> list2 = this.B.get(referenceType);
        if (list2 == null) {
            List<Object> list3 = Collections.emptyList();
            try {
                list3 = referenceType.nestedTypes();
            }
            catch (Throwable throwable) {
                C.info(throwable);
            }
            if (!list3.isEmpty()) {
                HashSet<Object> hashSet = new HashSet<Object>();
                ClassLoaderReference classLoaderReference = referenceType.classLoader();
                for (Object object : list3) {
                    try {
                        if (!(classLoaderReference == null ? object.classLoader() == null : classLoaderReference.equals(object.classLoader()))) continue;
                        hashSet.add(object);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!hashSet.isEmpty()) {
                    HashSet hashSet2 = new HashSet();
                    for (ReferenceType referenceType2 : hashSet) {
                        hashSet2.addAll(this.nestedTypes(referenceType2));
                    }
                    hashSet.removeAll(hashSet2);
                }
                list2 = hashSet.isEmpty() ? Collections.emptyList() : new ArrayList(hashSet);
            } else {
                list2 = Collections.emptyList();
            }
            this.B.put(referenceType, list2);
        }
        return list2;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> list2 = this.w;
        if (list2 == null) {
            this.w = list2 = this.y.allClasses();
        }
        return list2;
    }

    public String toString() {
        return this.y.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.y.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.D) {
            this.D = false;
            for (ThreadReference threadReference : this.y.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.v.values());
    }

    public void threadStarted(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(threadReference);
    }

    public void threadStopped(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.v.remove(threadReference);
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.n;
        this.y.suspend();
        this.clearCaches();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.n > 0) {
            --this.n;
        }
        this.clearCaches();
        C.debug("before resume VM");
        try {
            this.y.resume();
        }
        catch (InternalException internalException) {
            C.info((Throwable)internalException);
        }
        C.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return StreamEx.of(this.getVirtualMachine().topLevelThreadGroups()).map(this::getThreadGroupReferenceProxy).toList();
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.u.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.a(this.getVirtualMachine());
    }

    private static boolean a(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.u.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.y.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.y.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() throws EvaluateException {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.y.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean bl2) {
        return this.y.mirrorOf(bl2);
    }

    public ByteValue mirrorOf(byte by2) {
        return this.y.mirrorOf(by2);
    }

    public CharValue mirrorOf(char c2) {
        return this.y.mirrorOf(c2);
    }

    public ShortValue mirrorOf(short s2) {
        return this.y.mirrorOf(s2);
    }

    public IntegerValue mirrorOf(int n2) {
        return this.y.mirrorOf(n2);
    }

    public LongValue mirrorOf(long l2) {
        return this.y.mirrorOf(l2);
    }

    public FloatValue mirrorOf(float f2) {
        return this.y.mirrorOf(f2);
    }

    public DoubleValue mirrorOf(double d2) {
        return this.y.mirrorOf(d2);
    }

    public StringReference mirrorOf(String string) {
        return this.y.mirrorOf(string);
    }

    public StringReference mirrorOfStringLiteral(String string, ThrowableComputable<StringReference, EvaluateException> throwableComputable) throws EvaluateException {
        StringReference stringReference = this.a.get(string);
        if (stringReference != null && !stringReference.isCollected()) {
            return stringReference;
        }
        stringReference = (StringReference)throwableComputable.compute();
        this.a.put(string, stringReference);
        return stringReference;
    }

    public Process process() {
        return this.y.process();
    }

    public void dispose() {
        try {
            this.y.dispose();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            C.info((Throwable)unsupportedOperationException);
        }
        finally {
            Thread thread;
            TargetVM targetVM;
            if (Patches.JDK_BUG_EVENT_CONTROLLER_LEAK && (targetVM = (TargetVM)ReflectionUtil.getField(this.y.getClass(), (Object)this.y, TargetVM.class, (String)"target")) != null && (thread = (Thread)ReflectionUtil.getField(targetVM.getClass(), (Object)targetVM, Thread.class, (String)"eventController")) != null) {
                thread.stop();
            }
        }
    }

    public void exit(int n2) {
        this.y.exit(n2);
    }

    public boolean canWatchFieldModification() {
        return this.f.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.m.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.r.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.g.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.p.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.h.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.q.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.s.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.i.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.o.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.c.isAvailable();
    }

    public boolean canAddMethod() {
        return this.j.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.A.isAvailable();
    }

    public boolean canPopFrames() {
        return this.G.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.e.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.z.isAvailable();
    }

    public final boolean versionHigher(String string) {
        return this.y.version().compareTo(string) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.E.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.k.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.x.isAvailable();
    }

    public String getDefaultStratum() {
        return this.d ? this.y.getDefaultStratum() : null;
    }

    public String description() {
        return this.y.description();
    }

    public String version() {
        return this.y.version();
    }

    public String name() {
        return this.y.name();
    }

    public void setDebugTraceMode(int n2) {
        this.y.setDebugTraceMode(n2);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference threadReference2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadReference2 == null) {
            return null;
        }
        return this.v.computeIfAbsent(threadReference2, threadReference -> new ThreadReferenceProxyImpl(this, (ThreadReference)threadReference));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadGroupReference == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.u.get(threadGroupReference);
        if (threadGroupReferenceProxyImpl == null && !this.r.isAvailable()) {
            threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.u.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
        return threadGroupReferenceProxyImpl;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl objectReferenceProxyImpl = this.b.get(objectReference);
            if (objectReferenceProxyImpl == null) {
                objectReferenceProxyImpl = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.b.put(objectReference, objectReferenceProxyImpl);
            }
            return objectReferenceProxyImpl;
        }
        return null;
    }

    public boolean equals(Object object) {
        C.assertTrue(object instanceof VirtualMachineProxyImpl);
        return this.y.equals(((VirtualMachineProxyImpl)object).getVirtualMachine());
    }

    public int hashCode() {
        return this.y.hashCode();
    }

    public void clearCaches() {
        C.debug("VM cleared");
        this.w = null;
        if (!this.B.isEmpty()) {
            this.B = new HashMap<ReferenceType, List<ReferenceType>>(this.B.size());
        }
        ++this.t;
    }

    @Override
    public int getCurrentTime() {
        return this.t;
    }

    public DebugProcess getDebugProcess() {
        return this.F;
    }

    public static boolean isCollected(ObjectReference objectReference) {
        try {
            return !VirtualMachineProxyImpl.a(objectReference.virtualMachine()) && objectReference.isCollected();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            C.info((Throwable)unsupportedOperationException);
            return false;
        }
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.n > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(threadReferenceProxyImpl -> threadReferenceProxyImpl.getSuspendCount() != 0);
    }

    public void logThreads() {
        if (C.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : this.allThreads()) {
                if (threadReferenceProxyImpl.isCollected()) continue;
                C.debug("suspends " + threadReferenceProxyImpl + " " + threadReferenceProxyImpl.getSuspendCount() + " " + threadReferenceProxyImpl.isSuspended());
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Capability {
        private ThreeState a = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.a == ThreeState.UNSURE) {
                try {
                    this.a = ThreeState.fromBoolean((boolean)this.calcValue());
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    C.info((Throwable)vMDisconnectedException);
                    this.a = ThreeState.NO;
                }
            }
            return this.a.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static final Method typeNameToSignatureMethod = ReflectionUtil.getDeclaredMethod(JNITypeParser.class, (String)"typeNameToSignature", (Class[])new Class[]{String.class});

        JNITypeParserReflect() {
        }

        @Nullable
        static String typeNameToSignature(@NotNull String string) {
            if (string == null) {
                JNITypeParserReflect.a(0);
            }
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            if (typeNameToSignatureMethod == null) {
                C.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/jdi/VirtualMachineProxyImpl$JNITypeParserReflect", "typeNameToSignature"));
        }
    }
}

