/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.memory.action.ClassesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToTypeSourceAction
extends ClassesActionBase {
    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        PsiClass psiClass = this.a(anActionEvent);
        return super.isEnabled(anActionEvent) && psiClass != null && psiClass.isPhysical();
    }

    @Override
    protected void perform(AnActionEvent anActionEvent) {
        PsiClass psiClass = this.a(anActionEvent);
        if (psiClass != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)psiClass);
        }
    }

    @Nullable
    private PsiClass a(AnActionEvent anActionEvent) {
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        Project project2 = anActionEvent.getProject();
        if (referenceType == null || project2 == null) {
            return null;
        }
        ReferenceType referenceType2 = JumpToTypeSourceAction.a(referenceType);
        if (referenceType2 != null) {
            return DebuggerUtils.findClass((String)referenceType2.name(), (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
        }
        return null;
    }

    @Nullable
    private static ReferenceType a(@NotNull ReferenceType referenceType) {
        if (referenceType == null) {
            JumpToTypeSourceAction.a(0);
        }
        if (!(referenceType instanceof ArrayType)) {
            return referenceType;
        }
        String string = referenceType.name().replace("[]", "");
        VirtualMachine virtualMachine = referenceType.virtualMachine();
        List<ReferenceType> list2 = virtualMachine.classesByName(string);
        if (list2.size() == 1) {
            return list2.get(0);
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/action/JumpToTypeSourceAction", "getObjectType"));
    }
}

