/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ReferenceType;

public class ShowInstancesFromClassesViewAction
extends ShowInstancesAction {
    private static final String a = "Show Instances";

    @Override
    protected void perform(AnActionEvent anActionEvent) {
        XDebugSession xDebugSession;
        Project project2 = anActionEvent.getProject();
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        if (project2 != null && referenceType != null && (xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            new InstancesWindow(xDebugSession, n2 -> referenceType.instances(n2), referenceType.name()).show();
        }
    }

    @Override
    protected String getLabel() {
        return a;
    }

    @Override
    protected int getInstancesCount(AnActionEvent anActionEvent) {
        ClassesTable.ReferenceCountProvider referenceCountProvider = (ClassesTable.ReferenceCountProvider)anActionEvent.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        ReferenceType referenceType = this.getSelectedClass(anActionEvent);
        if (referenceCountProvider == null || referenceType == null) {
            return -1;
        }
        return referenceCountProvider.getTotalCount(referenceType);
    }
}

