/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesTree;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class InstancesWindow
extends DialogWrapper {
    private static final Logger c = Logger.getInstance(InstancesWindow.class);
    private static final int b = 870;
    private static final int e = 400;
    private static final int f = 30;
    private static final int a = 5;
    private static final int j = 500000;
    private final Project h;
    private final DebugProcessImpl k;
    private final InstancesProvider i;
    private final String d;
    private final MyInstancesView g;

    public InstancesWindow(@NotNull XDebugSession xDebugSession, @NotNull InstancesProvider instancesProvider, @NotNull String string) {
        if (xDebugSession == null) {
            InstancesWindow.a(0);
        }
        if (instancesProvider == null) {
            InstancesWindow.a(1);
        }
        if (string == null) {
            InstancesWindow.a(2);
        }
        super(xDebugSession.getProject(), false);
        this.h = xDebugSession.getProject();
        this.k = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.h).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
        this.i = instancesProvider;
        this.d = string;
        this.a(null);
        xDebugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesWindow.this.close(0));
            }
        }, this.myDisposable);
        this.setModal(false);
        this.g = new MyInstancesView(xDebugSession);
        this.g.setPreferredSize((Dimension)new JBDimension(870, 400));
        this.init();
        JRootPane jRootPane = this.g.getRootPane();
        jRootPane.setDefaultButton(this.g.i);
    }

    private void a(@Nullable String string) {
        String string2 = string == null ? "" : String.format(". Warning: %s", string);
        this.setTitle(String.format("Instances of %s%s", this.d, string2));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if ("#org.jetbrains.debugger.memory.view.InstancesWindow" == null) {
            InstancesWindow.a(3);
        }
        return "#org.jetbrains.debugger.memory.view.InstancesWindow";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.g;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        if (jComponent != null) {
            jComponent.add((Component)((Object)this.g.g), "West");
        }
        return jComponent;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Close", 1)};
        if (actionArray == null) {
            InstancesWindow.a(4);
        }
        return actionArray;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesWindow";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project2) {
            super(project2, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(NodeDescriptor nodeDescriptor, EvaluationContext evaluationContext) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, nodeDescriptor);
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.c(0);
            }
            return debuggerTreeNodeImpl;
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor messageDescriptor) {
            return new DebuggerTreeNodeImpl(null, messageDescriptor);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(String string) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(string));
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.c(1);
            }
            return debuggerTreeNodeImpl;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/memory/ui/InstancesWindow$MyNodeManager";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessageNode";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyValuesList
    implements FilteringTask.ValuesList {
        private final List<ObjectReference> a;

        public MyValuesList(List<ObjectReference> list2) {
            this.a = list2;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public ObjectReference get(int n2) {
            return this.a.get(n2);
        }
    }

    private class MyInstancesView
    extends JBPanel
    implements Disposable {
        private static final int l = 2000;
        private static final int f = 50;
        private static final int a = 3;
        private static final int h = 17;
        private final InstancesTree e;
        private final XDebuggerExpressionEditor b;
        private final XDebugSessionListener d;
        private final MyNodeManager j;
        private final JButton i;
        private final FilteringProgressView g;
        private final Object m;
        private boolean c;
        private volatile MyFilteringWorker k;

        MyInstancesView(XDebugSession xDebugSession) {
            Object object;
            if (xDebugSession == null) {
                MyInstancesView.a(0);
            }
            super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)));
            this.d = new MySessionListener();
            this.j = new MyNodeManager(InstancesWindow.this.h);
            this.i = new JButton("Filter");
            this.g = new FilteringProgressView();
            this.m = new Object();
            this.c = false;
            this.k = null;
            Disposer.register((Disposable)InstancesWindow.this.myDisposable, (Disposable)this);
            XValueMarkers<?, ?> xValueMarkers = this.a(xDebugSession);
            if (xValueMarkers != null) {
                object = new MyActionListener(xValueMarkers);
                ActionManager.getInstance().addAnActionListener((AnActionListener)object, InstancesWindow.this.myDisposable);
            }
            xDebugSession.addSessionListener(this.d, InstancesWindow.this.myDisposable);
            object = new JavaDebuggerEditorsProvider();
            this.b = new ExpressionEditorWithHistory(InstancesWindow.this.h, InstancesWindow.this.d, (XDebuggerEditorsProvider)object, InstancesWindow.this.myDisposable);
            Dimension dimension = this.b.getEditorComponent().getPreferredSize();
            dimension.width = JBUI.scale((int)30) + this.i.getPreferredSize().width;
            this.i.setPreferredSize(dimension);
            JBPanel jBPanel = new JBPanel((LayoutManager)new BorderLayout(JBUI.scale((int)5), 0));
            JBLabel jBLabel = new JBLabel("Warning: filtering may have side effects", 4);
            jBLabel.setBorder((Border)JBUI.Borders.emptyTop((int)1));
            jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            jBPanel.add((Component)new JBLabel("Condition:"), (Object)"West");
            jBPanel.add((Component)this.b.getComponent(), (Object)"Center");
            jBPanel.add((Component)this.i, (Object)"East");
            jBPanel.add((Component)jBLabel, (Object)"South");
            this.g.addStopActionListener(this::a);
            this.e = new InstancesTree(InstancesWindow.this.h, (XDebuggerEditorsProvider)object, xValueMarkers, this::b);
            this.i.addActionListener(actionEvent -> {
                String string = this.b.getExpression().getExpression();
                if (!string.isEmpty()) {
                    this.b.saveTextInHistory();
                }
                this.i.setEnabled(false);
                this.e.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
            });
            final StackFrameList stackFrameList = new StackFrameList(InstancesWindow.this.k);
            stackFrameList.addListSelectionListener(listSelectionEvent -> stackFrameList.navigateToSelectedValue(false));
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent mouseEvent) {
                    stackFrameList.navigateToSelectedValue(true);
                    return true;
                }
            }.installOn((Component)((Object)stackFrameList));
            InstancesWithStackFrameView instancesWithStackFrameView = new InstancesWithStackFrameView(xDebugSession, this.e, stackFrameList, InstancesWindow.this.d);
            this.add((Component)jBPanel, "North");
            this.add(instancesWithStackFrameView.getComponent(), "Center");
            JComponent jComponent = this.b.getEditorComponent();
            UiNotifyConnector.doWhenFirstShown((JComponent)jComponent, () -> IdeFocusManager.findInstanceByComponent((Component)jComponent).requestFocus((Component)jComponent, true));
        }

        public void dispose() {
            this.a();
            Disposer.dispose((Disposable)this.e);
        }

        private void b() {
            this.a();
            final XExpression xExpression = this.b.getExpression();
            InstancesWindow.this.k.getManagerThread().schedule(new DebuggerContextCommandImpl(InstancesWindow.this.k.getDebuggerContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.LOWEST;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                    if (suspendContextImpl == null) {
                        2.c(0);
                    }
                    MyInstancesView.this.c = AndroidUtil.isAndroidVM(InstancesWindow.this.k.getVirtualMachineProxy().getVirtualMachine());
                    int n2 = MyInstancesView.this.c ? 30000 : 500000;
                    List<ObjectReference> list2 = InstancesWindow.this.i.getInstances(n2 + 1);
                    EvaluationContextImpl evaluationContextImpl = InstancesWindow.this.k.getDebuggerContext().createEvaluationContext();
                    if (list2.size() > n2) {
                        InstancesWindow.this.a(String.format("Not all instances will be loaded (only %d)", n2));
                        list2 = list2.subList(0, n2);
                    }
                    if (evaluationContextImpl != null) {
                        Object object = MyInstancesView.this.m;
                        synchronized (object) {
                            MyInstancesView.this.k = new MyFilteringWorker(list2, xExpression, evaluationContextImpl);
                            MyInstancesView.this.k.execute();
                        }
                    }
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$2", "threadAction"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() {
            if (this.k != null) {
                Object object = this.m;
                synchronized (object) {
                    if (this.k != null) {
                        this.k.cancel();
                        this.k = null;
                    }
                }
            }
        }

        private XValueMarkers<?, ?> a(@NotNull XDebugSession xDebugSession) {
            if (xDebugSession == null) {
                MyInstancesView.a(1);
            }
            return xDebugSession instanceof XDebugSessionImpl ? ((XDebugSessionImpl)xDebugSession).getValueMarkers() : null;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "session";
            objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValueMarkers";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyFilteringWorker
        extends SwingWorker<Void, Void> {
            private final FilteringTask a;

            MyFilteringWorker(@NotNull List<ObjectReference> list2, @NotNull XExpression xExpression, EvaluationContextImpl evaluationContextImpl) {
                if (list2 == null) {
                    MyFilteringWorker.a(0);
                }
                if (xExpression == null) {
                    MyFilteringWorker.a(1);
                }
                if (evaluationContextImpl == null) {
                    MyFilteringWorker.a(2);
                }
                this.a = new FilteringTask(InstancesWindow.this.d, InstancesWindow.this.k, xExpression, new MyValuesList(list2), new MyFilteringCallback(evaluationContextImpl));
            }

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    this.a.run();
                }
                catch (Throwable throwable) {
                    c.error(throwable);
                }
                return null;
            }

            public void cancel() {
                this.a.cancel();
                super.cancel(false);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "refs";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "evaluationContext";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringWorker";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class MyFilteringCallback
        implements FilteringTaskCallback {
            private final ErrorsValueGroup d;
            private final EvaluationContextImpl b;
            private long i;
            private int g;
            private int c;
            private int f;
            private long a;
            private long e;
            private XValueChildrenList h;

            public MyFilteringCallback(EvaluationContextImpl evaluationContextImpl) {
                if (evaluationContextImpl == null) {
                    MyFilteringCallback.b(0);
                }
                this.d = new ErrorsValueGroup();
                this.g = 0;
                this.c = 0;
                this.f = 0;
                this.h = new XValueChildrenList();
                this.b = evaluationContextImpl;
            }

            @Override
            public void started(int n2) {
                this.a = this.i = System.nanoTime();
                this.e = System.nanoTime();
                ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.g.start(n2));
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action matched(@NotNull Value value) {
                if (value == null) {
                    MyFilteringCallback.b(1);
                }
                InstanceJavaValue instanceJavaValue = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.h, value), this.b, MyInstancesView.this.j);
                ++this.c;
                ++this.g;
                this.h.add((XNamedValue)instanceJavaValue);
                this.a();
                this.b();
                FilteringTaskCallback.Action action = this.c < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
                if (action == null) {
                    MyFilteringCallback.b(2);
                }
                return action;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action notMatched(@NotNull Value value) {
                if (value == null) {
                    MyFilteringCallback.b(3);
                }
                ++this.g;
                this.a();
                FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
                if (action == null) {
                    MyFilteringCallback.b(4);
                }
                return action;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action error(@NotNull Value value, @NotNull String string) {
                if (value == null) {
                    MyFilteringCallback.b(5);
                }
                if (string == null) {
                    MyFilteringCallback.b(6);
                }
                InstanceJavaValue instanceJavaValue = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.h, value), this.b, MyInstancesView.this.j);
                this.d.addErrorValue(string, instanceJavaValue);
                ++this.g;
                ++this.f;
                this.a();
                FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
                if (action == null) {
                    MyFilteringCallback.b(7);
                }
                return action;
            }

            @Override
            public void completed(@NotNull FilteringResult filteringResult) {
                if (filteringResult == null) {
                    MyFilteringCallback.b(8);
                }
                if (!this.d.isEmpty()) {
                    this.h.addBottomGroup((XValueGroup)this.d);
                }
                long l2 = System.nanoTime() - this.i;
                c.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(l2), this.g));
                int n2 = this.g;
                int n3 = this.c;
                int n4 = this.f;
                XValueChildrenList xValueChildrenList = this.h;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (filteringResult == null) {
                        MyFilteringCallback.b(9);
                    }
                    MyInstancesView.this.g.updateProgress(n2, n3, n4);
                    MyInstancesView.this.e.addChildren(xValueChildrenList, true);
                    MyInstancesView.this.i.setEnabled(true);
                    MyInstancesView.this.g.complete(filteringResult);
                });
            }

            private void a() {
                long l2 = System.nanoTime();
                if (l2 - this.e > TimeUnit.MILLISECONDS.toNanos(17L)) {
                    int n2 = this.g;
                    int n3 = this.c;
                    int n4 = this.f;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.g.updateProgress(n2, n3, n4));
                    this.e = l2;
                }
            }

            private void b() {
                long l2 = System.nanoTime();
                int n2 = this.h.size();
                if (n2 >= 50 || n2 > 0 && l2 - this.a > TimeUnit.SECONDS.toNanos(3L)) {
                    XValueChildrenList xValueChildrenList = this.h;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.e.addChildren(xValueChildrenList, false));
                    this.h = new XValueChildrenList();
                    this.a = System.nanoTime();
                }
            }

            private static /* synthetic */ void b(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "evaluationContext";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringCallback";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringCallback";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "matched";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "notMatched";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "error";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "matched";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "notMatched";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "error";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "completed";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$completed$1";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyActionListener
        extends AnActionListener.Adapter {
            private final XValueMarkers<?, ?> a;

            private MyActionListener(XValueMarkers<?, ?> xValueMarkers) {
                if (xValueMarkers == null) {
                    MyActionListener.a(0);
                }
                this.a = xValueMarkers;
            }

            public void beforeActionPerformed(AnAction anAction, DataContext dataContext, AnActionEvent anActionEvent) {
                XValueNodeImpl xValueNodeImpl;
                if (dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT) == MyInstancesView.this.e && (this.a(anAction) || this.b(anAction)) && (xValueNodeImpl = XDebuggerTreeActionBase.getSelectedNode((DataContext)dataContext)) != null) {
                    Object object = xValueNodeImpl;
                    while (!MyInstancesView.this.e.getRoot().equals(object.getParent())) {
                        object = object.getParent();
                    }
                    XValue xValue = (XValue)object.getValueContainer();
                    String string = xValue.getEvaluationExpression();
                    if (string != null) {
                        this.a.markValue(xValue, new ValueMarkup(string.replace("@", ""), (Color)new JBColor(0, 0), null));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.e.rebuildTree(InstancesTree.RebuildPolicy.ONLY_UPDATE_LABELS));
                }
            }

            private boolean a(AnAction anAction) {
                String string = anAction.getClass().getSimpleName();
                return anAction instanceof XDebuggerTreeActionBase && string.equals("XAddToWatchesAction");
            }

            private boolean b(AnAction anAction) {
                String string = anAction.getClass().getSimpleName();
                return anAction instanceof XDebuggerActionBase && string.equals("EvaluateAction");
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyActionListener", "<init>"));
            }
        }

        private class MySessionListener
        implements XDebugSessionListener {
            private volatile XDebuggerTreeState a = null;

            private MySessionListener() {
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.a = XDebuggerTreeState.saveState((XDebuggerTree)MyInstancesView.this.e);
                    MyInstancesView.this.a();
                    MyInstancesView.this.e.setInfoMessage("The application is running");
                });
            }

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MyInstancesView.this.g.setVisible(true);
                    XDebuggerTreeState xDebuggerTreeState = this.a;
                    if (xDebuggerTreeState != null) {
                        MyInstancesView.this.e.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES, xDebuggerTreeState);
                    } else {
                        MyInstancesView.this.e.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
                    }
                });
            }
        }
    }
}

