/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class StackFrameList
extends XDebuggerFramesList {
    private static final MyOpenFilesState b = new MyOpenFilesState();
    private final DebugProcessImpl a;

    StackFrameList(DebugProcessImpl debugProcessImpl) {
        super(debugProcessImpl.getProject());
        this.a = debugProcessImpl;
    }

    void setFrameItems(@NotNull List<StackFrameItem> list2) {
        if (list2 == null) {
            StackFrameList.a(0);
        }
        this.setFrameItems(list2, null);
    }

    void setFrameItems(final @NotNull List<StackFrameItem> list2, final Runnable runnable) {
        if (list2 == null) {
            StackFrameList.a(1);
        }
        this.clear();
        if (!list2.isEmpty()) {
            this.a.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    boolean bl2 = false;
                    for (StackFrameItem stackFrameItem : list2) {
                        if (stackFrameItem == null) {
                            bl2 = true;
                            continue;
                        }
                        StackFrameItem.CapturedStackFrame capturedStackFrame = stackFrameItem.createFrame(StackFrameList.this.a);
                        capturedStackFrame.setWithSeparator(bl2);
                        DebuggerUIUtil.invokeLater(() -> StackFrameList.this.getModel().add((Object)capturedStackFrame));
                        bl2 = false;
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    protected void onFrameChanged(Object object) {
        this.a(object, false);
    }

    void navigateToSelectedValue(boolean bl2) {
        this.a(this.getSelectedValue(), bl2);
    }

    private void a(Object object, boolean bl2) {
        if (object instanceof XStackFrame) {
            this.a((XStackFrame)object, bl2);
        }
    }

    private void a(@NotNull XStackFrame xStackFrame, boolean bl2) {
        XSourcePosition xSourcePosition;
        if (xStackFrame == null) {
            StackFrameList.a(2);
        }
        if ((xSourcePosition = xStackFrame.getSourcePosition()) == null) {
            return;
        }
        VirtualFile virtualFile = xSourcePosition.getFile();
        int n2 = xSourcePosition.getLine();
        Project project2 = this.a.getProject();
        OpenFileHyperlinkInfo openFileHyperlinkInfo = new OpenFileHyperlinkInfo(project2, virtualFile, n2);
        OpenFileDescriptor openFileDescriptor = openFileHyperlinkInfo.getDescriptor();
        if (openFileDescriptor != null) {
            FileEditorManagerImpl fileEditorManagerImpl = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project2);
            VirtualFile virtualFile2 = StackFrameList.b.myLastOpenedFile;
            if (StackFrameList.b.myIsNeedToCloseLastOpenedFile && virtualFile2 != null && fileEditorManagerImpl.isFileOpen(virtualFile2) && !virtualFile2.equals(openFileDescriptor.getFile())) {
                fileEditorManagerImpl.closeFile(StackFrameList.b.myLastOpenedFile, false, true);
            }
            openFileDescriptor.setScrollType(ScrollType.CENTER);
            openFileDescriptor.setUseCurrentWindow(true);
            if (virtualFile2 == null || !virtualFile2.equals(openFileDescriptor.getFile())) {
                StackFrameList.b.myIsNeedToCloseLastOpenedFile = !fileEditorManagerImpl.isFileOpen(openFileDescriptor.getFile());
            }
            openFileDescriptor.navigateInEditor(project2, bl2);
            FileEditor[] fileEditorArray = fileEditorManagerImpl.getEditors(openFileDescriptor.getFile());
            if (fileEditorArray.length != 0) {
                StackFrameList.b.myLastOpenedFile = openFileDescriptor.getFile();
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/StackFrameList";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFrameItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyOpenFilesState {
        VirtualFile myLastOpenedFile;
        boolean myIsNeedToCloseLastOpenedFile;

        private MyOpenFilesState() {
        }
    }
}

