/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class NamesUtils {
    NamesUtils() {
    }

    @NotNull
    static String getUniqueName(@NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            NamesUtils.a(0);
        }
        String string = StringUtil.getShortName((String)objectReference.referenceType().name());
        String string2 = string.replace("[]", "Array");
        String string3 = String.format("%s@%d", string2, objectReference.uniqueID());
        if (string3 == null) {
            NamesUtils.a(1);
        }
        return string3;
    }

    @NotNull
    static String getArrayUniqueName(@NotNull ArrayReference arrayReference) {
        if (arrayReference == null) {
            NamesUtils.a(2);
        }
        String string = StringUtil.getShortName((String)arrayReference.referenceType().name());
        int n2 = arrayReference.length();
        String string2 = string.replaceFirst(Pattern.quote("[]"), String.format("[%d]", n2));
        String string3 = String.format("%s@%d", string2, arrayReference.uniqueID());
        if (string3 == null) {
            NamesUtils.a(3);
        }
        return string3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/utils/NamesUtils";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/utils/NamesUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayUniqueName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueName";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArrayUniqueName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

