/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;

public class CaptureSettingsProvider {
    private static final List<AgentCapturePoint> c = new ArrayList<AgentCapturePoint>();
    private static final List<AgentInsertPoint> a = new ArrayList<AgentInsertPoint>();
    private static final List<CapturePoint> b;
    private static final KeyProvider e;
    private static final KeyProvider d;

    public static List<AgentPoint> getPoints() {
        List list2 = ContainerUtil.concat(c, a);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list2 = ContainerUtil.concat((List)list2, CaptureSettingsProvider.a());
        }
        return list2;
    }

    public static List<CapturePoint> getIdeInsertPoints() {
        List list2 = Collections.unmodifiableList(b);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list2 = ContainerUtil.concat(list2, (List)StreamEx.of(CaptureSettingsProvider.a()).select(AgentInsertPoint.class).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList());
        }
        return list2;
    }

    private static List<AgentPoint> a() {
        return (List)ReadAction.compute(() -> {
            ArrayList arrayList = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                PsiAnnotationMemberValue psiAnnotationMemberValue;
                Object object;
                Object object2;
                KeyProvider keyProvider;
                PsiMethod psiMethod;
                if (psiModifierListOwner instanceof PsiMethod) {
                    psiMethod = (PsiMethod)psiModifierListOwner;
                    keyProvider = e;
                } else if (psiModifierListOwner instanceof PsiParameter) {
                    object2 = (PsiParameter)psiModifierListOwner;
                    psiMethod = (PsiMethod)object2.getDeclarationScope();
                    keyProvider = CaptureSettingsProvider.a(psiMethod.getParameterList().getParameterIndex(object2));
                } else {
                    return;
                }
                object2 = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass()).replaceAll("\\.", "/");
                String string = JVMNameUtil.getJVMMethodName(psiMethod);
                PsiModifierList psiModifierList = psiModifierListOwner.getModifierList();
                if (psiModifierList != null && (object = psiModifierList.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null && (psiAnnotationMemberValue = object.findAttributeValue("keyExpression")) != null && !"\"\"".equals(psiAnnotationMemberValue.getText())) {
                    keyProvider = new FieldKeyProvider((String)object2, StringUtil.unquoteString((String)psiAnnotationMemberValue.getText()));
                }
                object = bl2 != false ? new AgentCapturePoint((String)object2, string, keyProvider) : new AgentInsertPoint((String)object2, string, keyProvider);
                arrayList.add(object);
            });
            return arrayList;
        });
    }

    private static KeyProvider a(int n2) {
        return new StringKeyProvider(Integer.toString(n2));
    }

    private static void b(String string, String string2, KeyProvider keyProvider) {
        c.add(new AgentCapturePoint(string, string2, keyProvider));
    }

    private static void a(String string, String string2, KeyProvider keyProvider) {
        a.add(new AgentInsertPoint(string, string2, keyProvider));
    }

    static {
        e = new StringKeyProvider("this");
        d = CaptureSettingsProvider.a(0);
        CaptureSettingsProvider.b("java/awt/event/InvocationEvent", "<init>", e);
        CaptureSettingsProvider.a("java/awt/event/InvocationEvent", "dispatch", e);
        CaptureSettingsProvider.b("java/lang/Thread", "start", e);
        CaptureSettingsProvider.a("java/lang/Thread", "run", e);
        CaptureSettingsProvider.b("java/util/concurrent/FutureTask", "<init>", e);
        CaptureSettingsProvider.a("java/util/concurrent/FutureTask", "run", e);
        CaptureSettingsProvider.a("java/util/concurrent/FutureTask", "runAndReset", e);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "supplyAsync", d);
        AgentInsertPoint agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncSupply", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncSupply", "fn"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        a.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "runAsync", d);
        agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncRun", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncRun", "fn"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        a.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenAcceptAsync", d);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniAccept", "fn"));
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenRunAsync", d);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniRun", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniRun", "fn"));
        CaptureSettingsProvider.b("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", d);
        CaptureSettingsProvider.a("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", d);
        CaptureSettingsProvider.b("scala/concurrent/impl/Future$PromiseCompletingRunnable", "<init>", e);
        CaptureSettingsProvider.a("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", e);
        CaptureSettingsProvider.b("scala/concurrent/impl/CallbackRunnable", "<init>", e);
        CaptureSettingsProvider.a("scala/concurrent/impl/CallbackRunnable", "run", e);
        CaptureSettingsProvider.b("akka/actor/ScalaActorRef", "$bang", d);
        CaptureSettingsProvider.b("akka/actor/RepointableActorRef", "$bang", d);
        CaptureSettingsProvider.b("akka/actor/LocalActorRef", "$bang", d);
        CaptureSettingsProvider.a("akka/actor/Actor$class", "aroundReceive", CaptureSettingsProvider.a(2));
        b = StreamEx.of(a).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList();
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String a;
        private final String b;

        public FieldKeyProvider(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        public String asString() {
            return this.a + " " + this.b;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String a;

        public StringKeyProvider(String string) {
            this.a = string;
        }

        @Override
        public String asString() {
            return this.a;
        }
    }

    public static interface KeyProvider {
        public String asString();
    }

    public static class AgentInsertPoint
    extends AgentPoint {
        public final CapturePoint myInsertPoint = new CapturePoint();

        public AgentInsertPoint(String string, String string2, KeyProvider keyProvider) {
            super(string, string2, keyProvider);
            this.myInsertPoint.myInsertClassName = string.replaceAll("/", ".");
            this.myInsertPoint.myInsertMethodName = string2;
            if (this.myKey instanceof FieldKeyProvider) {
                this.myInsertPoint.myInsertKeyExpression = ((FieldKeyProvider)this.myKey).b;
            } else {
                String string3 = keyProvider.asString();
                try {
                    this.myInsertPoint.myInsertKeyExpression = "param_" + Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.myInsertPoint.myInsertKeyExpression = string3;
                }
            }
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    public static class AgentCapturePoint
    extends AgentPoint {
        public AgentCapturePoint(String string, String string2, KeyProvider keyProvider) {
            super(string, string2, keyProvider);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    public static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final KeyProvider myKey;
        public static final String SEPARATOR = " ";

        public AgentPoint(String string, String string2, KeyProvider keyProvider) {
            assert (!string.contains(".")) : "Classname should not contain . here";
            this.myClassName = string;
            this.myMethodName = string2;
            this.myKey = keyProvider;
        }

        public abstract boolean isCapture();
    }
}

