/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", defaultStateAsResource=true, storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger b = Logger.getInstance(DebuggerSettings.class);
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    public boolean TRACING_FILTERS_ENABLED = true;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM = true;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS = true;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS = true;
    public String RUN_HOTSWAP_AFTER_COMPILE = "RunHotswapAsk";
    public boolean COMPILE_BEFORE_HOTSWAP = true;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] e = ClassFilter.EMPTY_ARRAY;
    public boolean INSTRUMENTING_AGENT = true;
    private List<CapturePoint> a = new ArrayList<CapturePoint>();
    public boolean CAPTURE_VARIABLES;
    private final EventDispatcher<CapturePointsSettingsListener> d = EventDispatcher.create(CapturePointsSettingsListener.class);
    private Map<String, ContentState> c = new LinkedHashMap();

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] classFilterArray = new ClassFilter[this.e.length];
        for (int i2 = 0; i2 < classFilterArray.length; ++i2) {
            classFilterArray[i2] = this.e[i2].clone();
        }
        return classFilterArray;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] classFilterArray) {
        this.e = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultsSerializationFilter());
        try {
            DebuggerUtilsEx.writeFilters(element, "filter", this.e);
        }
        catch (WriteExternalException writeExternalException) {
            b.error((Throwable)writeExternalException);
            return null;
        }
        for (ContentState contentState : this.c.values()) {
            Element element2;
            if (!contentState.write(element2 = new Element("content"))) continue;
            element.addContent(element2);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            DebuggerSettings.a(0);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        try {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(element.getChildren("filter")));
        }
        catch (InvalidDataException invalidDataException) {
            b.error((Throwable)invalidDataException);
        }
        this.c.clear();
        for (Element element2 : element.getChildren("content")) {
            ContentState contentState = new ContentState(element2);
            this.c.put(contentState.getType(), contentState);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings debuggerSettings = (DebuggerSettings)object;
        return this.TRACING_FILTERS_ENABLED == debuggerSettings.TRACING_FILTERS_ENABLED && this.DEBUGGER_TRANSPORT == debuggerSettings.DEBUGGER_TRANSPORT && StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)debuggerSettings.EVALUATE_FINALLY_ON_POP_FRAME) && this.FORCE_CLASSIC_VM == debuggerSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == debuggerSettings.DISABLE_JIT && this.SHOW_ALTERNATIVE_SOURCE == debuggerSettings.SHOW_ALTERNATIVE_SOURCE && this.KILL_PROCESS_IMMEDIATELY == debuggerSettings.KILL_PROCESS_IMMEDIATELY && this.HOTSWAP_IN_BACKGROUND == debuggerSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == debuggerSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == debuggerSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == debuggerSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == debuggerSettings.SKIP_GETTERS && this.RESUME_ONLY_CURRENT_THREAD == debuggerSettings.RESUME_ONLY_CURRENT_THREAD && this.COMPILE_BEFORE_HOTSWAP == debuggerSettings.COMPILE_BEFORE_HOTSWAP && this.HOTSWAP_HANG_WARNING_ENABLED == debuggerSettings.HOTSWAP_HANG_WARNING_ENABLED && (this.RUN_HOTSWAP_AFTER_COMPILE != null ? this.RUN_HOTSWAP_AFTER_COMPILE.equals(debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE) : debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE == null) && DebuggerUtilsEx.filterEquals(this.e, debuggerSettings.e) && this.a.equals(((DebuggerSettings)object).a);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings debuggerSettings = (DebuggerSettings)super.clone();
            debuggerSettings.c = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.c.entrySet()) {
                debuggerSettings.c.put(entry.getKey(), entry.getValue().clone());
            }
            debuggerSettings.e = new ClassFilter[this.e.length];
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                debuggerSettings.e[i2] = this.e[i2].clone();
            }
            debuggerSettings.a = this.cloneCapturePoints();
            return debuggerSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            b.error((Throwable)cloneNotSupportedException);
            return null;
        }
    }

    List<CapturePoint> cloneCapturePoints() {
        try {
            ArrayList<CapturePoint> arrayList = new ArrayList<CapturePoint>(this.a.size());
            for (CapturePoint capturePoint : this.a) {
                arrayList.add(capturePoint.clone());
            }
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            b.error((Throwable)cloneNotSupportedException);
            return Collections.emptyList();
        }
    }

    @XCollection(propertyElementName="capture-points")
    public List<CapturePoint> getCapturePoints() {
        return this.a;
    }

    public void setCapturePoints(List<CapturePoint> list2) {
        this.a = list2;
        ((CapturePointsSettingsListener)this.d.getMulticaster()).capturePointsChanged();
    }

    public void addCapturePointsSettingsListener(CapturePointsSettingsListener capturePointsSettingsListener, Disposable disposable) {
        this.d.addListener((EventListener)capturePointsSettingsListener, disposable);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/settings/DebuggerSettings", "loadState"));
    }

    public static interface CapturePointsSettingsListener
    extends EventListener {
        public void capturePointsChanged();
    }

    public static class ContentState
    implements Cloneable {
        private final String c;
        private boolean g;
        private String d;
        private double b;
        private boolean a;
        private boolean f;
        private boolean e;

        public ContentState(String string) {
            this.c = string;
        }

        public ContentState(Element element) {
            this.c = element.getAttributeValue("type");
            this.g = Boolean.parseBoolean(element.getAttributeValue("minimized"));
            this.e = Boolean.parseBoolean(element.getAttributeValue("maximized"));
            this.d = element.getAttributeValue("selected");
            String string = element.getAttributeValue("split");
            if (string != null) {
                this.b = Double.valueOf(string);
            }
            this.a = Boolean.parseBoolean(element.getAttributeValue("detached"));
            this.f = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.c);
            element.setAttribute("minimized", Boolean.valueOf(this.g).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.e).toString());
            if (this.d != null) {
                element.setAttribute("selected", this.d);
            }
            element.setAttribute("split", Double.toString(this.b));
            element.setAttribute("detached", Boolean.valueOf(this.a).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.f).toString());
            return true;
        }

        public String getType() {
            return this.c;
        }

        public String getSelectedTab() {
            return this.d;
        }

        public boolean isMinimized() {
            return this.g;
        }

        public void setMinimized(boolean bl2) {
            this.g = bl2;
        }

        public void setMaximized(boolean bl2) {
            this.e = bl2;
        }

        public boolean isMaximized() {
            return this.e;
        }

        public void setSelectedTab(String string) {
            this.d = string;
        }

        public void setSplitProportion(double d2) {
            this.b = d2;
        }

        public double getSplitProportion(double d2) {
            return this.b <= 0.0 || this.b >= 1.0 ? d2 : this.b;
        }

        public void setDetached(boolean bl2) {
            this.a = bl2;
        }

        public boolean isDetached() {
            return this.a;
        }

        public boolean isHorizontalToolbar() {
            return this.f;
        }

        public void setHorizontalToolbar(boolean bl2) {
            this.f = bl2;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

