/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.DebuggerTreeCreatorImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueHint
extends AbstractValueHint {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHint");
    private PsiElement c = null;
    private Value a = null;

    private ValueHint(Project project2, Editor editor, Point point, ValueHintType valueHintType, PsiElement psiElement, TextRange textRange) {
        super(project2, editor, point, valueHintType, textRange);
        this.c = psiElement;
    }

    public static ValueHint createValueHint(Project project2, Editor editor, Point point, ValueHintType valueHintType) {
        Trinity<PsiElement, TextRange, Value> trinity = ValueHint.a(project2, editor, point, valueHintType);
        ValueHint valueHint = new ValueHint(project2, editor, point, valueHintType, (PsiElement)trinity.getFirst(), (TextRange)trinity.getSecond());
        valueHint.a = (Value)trinity.getThird();
        return valueHint;
    }

    protected boolean canShowHint() {
        return this.c != null;
    }

    @Nullable
    private ExpressionEvaluator a(DebuggerContextImpl debuggerContextImpl) throws EvaluateException {
        if (this.c instanceof PsiExpression) {
            return EvaluatorBuilderImpl.getInstance().build(this.c, debuggerContextImpl.getSourcePosition());
        }
        TextWithImportsImpl textWithImportsImpl = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.c.getText());
        CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImportsImpl, this.c);
        JavaCodeFragment javaCodeFragment = codeFragmentFactory.createCodeFragment((TextWithImports)textWithImportsImpl, this.c.getContext(), this.getProject());
        return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, debuggerContextImpl.getSourcePosition());
    }

    protected void evaluateAndShowHint() {
        final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession == null || !debuggerSession.isPaused()) {
            return;
        }
        try {
            final ExpressionEvaluator expressionEvaluator = this.a(debuggerContextImpl);
            if (expressionEvaluator == null) {
                return;
            }
            debuggerContextImpl.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                    if (suspendContextImpl == null) {
                        1.c(0);
                    }
                    try {
                        EvaluationContextImpl evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
                        String string = (String)ReadAction.compute(() -> ValueHint.this.c.getText());
                        TextWithImportsImpl textWithImportsImpl = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
                        final Value value = ValueHint.this.a != null ? ValueHint.this.a : expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
                        final WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(ValueHint.this.getProject(), textWithImportsImpl, value);
                        if (!ValueHint.a(value) || ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                            if (ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                watchItemDescriptor.setRenderer(DebugProcessImpl.getDefaultRenderer(value));
                            }
                            watchItemDescriptor.updateRepresentation(evaluationContextImpl, new DescriptorLabelListener(){

                                @Override
                                public void labelChanged() {
                                    if (ValueHint.this.getCurrentRange() != null && (ValueHint.this.getType() != ValueHintType.MOUSE_OVER_HINT || watchItemDescriptor.isValueValid())) {
                                        SimpleColoredText simpleColoredText = DebuggerTreeRenderer.getDescriptorText(debuggerContextImpl, watchItemDescriptor, true);
                                        if (ValueHint.a(value)) {
                                            simpleColoredText.append(" (" + DebuggerBundle.message((String)"active.tooltip.suggestion", (Object[])new Object[0]) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                        }
                                        ValueHint.this.a(simpleColoredText, watchItemDescriptor);
                                    }
                                }
                            });
                        } else {
                            ValueHint.this.a(string, watchItemDescriptor);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        b.debug((Throwable)evaluateException);
                    }
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/ValueHint$1", "threadAction"));
                }
            });
        }
        catch (EvaluateException evaluateException) {
            b.debug((Throwable)evaluateException);
        }
    }

    private void a(String string, NodeDescriptorImpl nodeDescriptorImpl) {
        DebuggerTreeCreatorImpl debuggerTreeCreatorImpl = new DebuggerTreeCreatorImpl(this.getProject());
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> this.showTreePopup(debuggerTreeCreatorImpl, Pair.create((Object)nodeDescriptorImpl, (Object)string)));
    }

    private static boolean a(Value value) {
        return value != null && !(value instanceof PrimitiveValue);
    }

    private void a(SimpleColoredText simpleColoredText, final WatchItemDescriptor watchItemDescriptor) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.isHintHidden()) {
                JComponent jComponent = !ValueHint.a(watchItemDescriptor.getValue()) ? HintUtil.createInformationLabel((SimpleColoredText)simpleColoredText) : this.createExpandableHintComponent(simpleColoredText, () -> {
                    DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
                    final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
                    debugProcessImpl.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                        @Override
                        public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                            if (suspendContextImpl == null) {
                                2.c(0);
                            }
                            watchItemDescriptor.setRenderer(debugProcessImpl.getAutoRenderer(watchItemDescriptor));
                            String string = (String)ReadAction.compute(() -> ValueHint.this.c.getText());
                            ValueHint.this.a(string, watchItemDescriptor);
                        }

                        private static /* synthetic */ void c(int n2) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/ValueHint$2", "threadAction"));
                        }
                    });
                });
                if (!this.showHint(jComponent)) {
                    return;
                }
                if (this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                    HintUtil.createInformationLabel((SimpleColoredText)simpleColoredText).requestFocusInWindow();
                }
            }
        });
    }

    public static InspectDebuggerTree createInspectTree(NodeDescriptorImpl nodeDescriptorImpl, Project project2) {
        final InspectDebuggerTree inspectDebuggerTree = new InspectDebuggerTree(project2);
        final AnAction anAction = ActionManager.getInstance().getAction("Debugger.SetValue");
        anAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)inspectDebuggerTree));
        Disposer.register((Disposable)inspectDebuggerTree, (Disposable)new Disposable(){

            public void dispose() {
                anAction.unregisterCustomShortcutSet((JComponent)((Object)inspectDebuggerTree));
            }
        });
        inspectDebuggerTree.setInspectDescriptor(nodeDescriptorImpl);
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        inspectDebuggerTree.rebuild(debuggerContextImpl);
        return inspectDebuggerTree;
    }

    @Nullable
    private static Pair<PsiElement, TextRange> a(PsiElement psiElement, boolean bl2) {
        EditorTextProvider editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage());
        if (editorTextProvider != null) {
            return editorTextProvider.findExpression(psiElement, bl2);
        }
        return null;
    }

    private static Trinity<PsiElement, TextRange, Value> a(Project project2, Editor editor, Point point, ValueHintType valueHintType) {
        Ref ref = Ref.create(null);
        Ref ref2 = Ref.create(null);
        Ref ref3 = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            Object object;
            Pair<PsiElement, TextRange> pair2;
            PsiElement psiElement;
            int n2 = ValueHint.calculateOffset((Editor)editor, (Point)point);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null || !psiFile.isValid()) {
                return;
            }
            int n3 = editor.getSelectionModel().getSelectionStart();
            int n4 = editor.getSelectionModel().getSelectionEnd();
            if ((valueHintType == ValueHintType.MOUSE_CLICK_HINT || valueHintType == ValueHintType.MOUSE_ALT_OVER_HINT) && n3 <= n2 && n2 <= n4) {
                psiElement = n3 > 0 ? psiFile.findElementAt(n3 - 1) : psiFile.findElementAt(n3);
                try {
                    pair2 = editor.getSelectionModel().getSelectedText();
                    if (pair2 != null && psiElement != null) {
                        object = JVMElementFactories.getFactory((Language)psiElement.getLanguage(), (Project)project2);
                        if (object == null) {
                            return;
                        }
                        ref.set((Object)object.createExpressionFromText(pair2, psiElement));
                        ref2.set((Object)new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()));
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            if (ref2.get() == null) {
                PsiMethodCallExpression psiMethodCallExpression;
                PsiMethod psiMethod;
                Pair<PsiElement, TextRange> pair3;
                Method method;
                Pair<Method, Value> pair4;
                psiElement = psiFile.findElementAt(n2);
                if (psiElement == null) {
                    return;
                }
                pair2 = ValueHint.a(psiElement, valueHintType == ValueHintType.MOUSE_CLICK_HINT || valueHintType == ValueHintType.MOUSE_ALT_OVER_HINT);
                if (pair2 == null && valueHintType == ValueHintType.MOUSE_OVER_HINT && (object = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession()) != null && ((DebuggerSession)object).isPaused() && (pair4 = ((DebuggerSession)object).getProcess().getLastExecutedMethod()) != null && (method = (Method)pair4.getFirst()) != null && (pair3 = ValueHint.a(psiElement, true)) != null && pair3.getFirst() instanceof PsiMethodCallExpression && (psiMethod = (psiMethodCallExpression = (PsiMethodCallExpression)pair3.getFirst()).resolveMethod()) != null) {
                    JVMName jVMName = JVMNameUtil.getJVMSignature(psiMethod);
                    try {
                        if (method.name().equals(psiMethod.getName()) && method.signature().equals(jVMName.getName(((DebuggerSession)object).getProcess()))) {
                            pair2 = pair3;
                            ref3.set(pair4.getSecond());
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        // empty catch block
                    }
                }
                if (pair2 == null) {
                    return;
                }
                ref.set(pair2.getFirst());
                ref2.set(pair2.getSecond());
            }
        });
        return Trinity.create((Object)ref.get(), (Object)ref2.get(), (Object)ref3.get());
    }
}

