/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    private static final Logger h = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    @Nullable
    private SourcePosition c;
    private boolean g;
    private volatile Icon f;
    @Nullable
    private String d;
    @Nullable
    private String i;
    @Nullable
    private String e;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected abstract Icon getInvalidIcon(boolean var1);

    protected Icon getSetIcon(boolean bl2) {
        return null;
    }

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.f;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.d;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null && sourcePosition.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.i;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        if (!this.isValid()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
            this.c();
        }
        return this;
    }

    private void b(@Nullable DebugProcessImpl debugProcessImpl) {
        this.f = this.a(debugProcessImpl);
        this.d = JVMNameUtil.getSourcePositionClassDisplayName(debugProcessImpl, this.getSourcePosition());
        this.i = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcessImpl, this.getSourcePosition());
    }

    private Icon a(@Nullable DebugProcessImpl debugProcessImpl) {
        boolean bl2;
        boolean bl3 = bl2 = debugProcessImpl != null && this.isMuted(debugProcessImpl);
        if (!this.isEnabled()) {
            return this.getDisabledIcon(bl2);
        }
        this.e = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(bl2);
        }
        if (debugProcessImpl == null) {
            return this.getSetIcon(bl2);
        }
        RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
        boolean bl4 = this.myCachedVerifiedState || requestManagerImpl.isVerified(this);
        String string = requestManagerImpl.getWarning(this);
        if (string != null) {
            this.e = string;
            if (!bl4) {
                return this.getInvalidIcon(bl2);
            }
            return this.getVerifiedWarningsIcon(bl2);
        }
        if (bl4) {
            return this.getVerifiedIcon(bl2);
        }
        return this.getSetIcon(bl2);
    }

    protected BreakpointWithHighlighter(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            BreakpointWithHighlighter.b(0);
        }
        super(project2, xBreakpoint);
        this.g = true;
        this.f = this.getSetIcon(false);
        ApplicationManager.getApplication().runReadAction(this::reload);
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(@Nullable XSourcePosition xSourcePosition) {
        return (Boolean)ReadAction.compute(() -> xSourcePosition != null && xSourcePosition.getFile().isValid());
    }

    @Nullable
    public SourcePosition getSourcePosition() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDescription() {
        Object[] objectArray;
        StringBuilder stringBuilder;
        block8: {
            stringBuilder = StringBuilderSpinAllocator.alloc();
            stringBuilder.append(this.getDisplayName());
            if (this.isCountFilterEnabled()) {
                stringBuilder.append("&nbsp;<br>&nbsp;");
                stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
                stringBuilder.append(this.getCountFilter());
            }
            if (this.isClassFiltersEnabled()) {
                stringBuilder.append("&nbsp;<br>&nbsp;");
                stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
                for (ClassFilter classFilter : objectArray = this.getClassFilters()) {
                    stringBuilder.append(classFilter.getPattern()).append(" ");
                }
            }
            if (this.isInstanceFiltersEnabled()) {
                stringBuilder.append("&nbsp;<br>&nbsp;");
                stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
                for (ClassFilter classFilter : objectArray = this.getInstanceFilters()) {
                    stringBuilder.append(Long.toString(classFilter.getId())).append(" ");
                }
            }
            objectArray = stringBuilder.toString();
            if (objectArray != null) break block8;
            BreakpointWithHighlighter.b(1);
        }
        return objectArray;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    @Override
    public void reload() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.c = DebuggerUtilsEx.toSourcePosition(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (this.c != null) {
            this.reload(this.c.getFile());
        }
    }

    @Nullable
    static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor filteredRequestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcessImpl) {
        if (filteredRequestor == null) {
            BreakpointWithHighlighter.b(2);
        }
        if (debugProcessImpl == null) {
            BreakpointWithHighlighter.b(3);
        }
        if (location != null) {
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            BreakpointRequest breakpointRequest = requestManagerImpl.createBreakpointRequest(filteredRequestor, location);
            requestManagerImpl.enableRequest(breakpointRequest);
            return breakpointRequest;
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            BreakpointWithHighlighter.b(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcessImpl)) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null) {
            this.createOrWaitPrepare(debugProcessImpl, sourcePosition);
        } else {
            h.error("Unable to create request for breakpoint with null position: " + this.toString() + " at " + this.myXBreakpoint.getSourcePosition());
        }
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            BreakpointWithHighlighter.b(5);
        }
        return debugProcessImpl.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)debugProcess;
        if (this.shouldCreateRequest(debugProcessImpl, true)) {
            this.createRequestForPreparedClass(debugProcessImpl, referenceType);
            this.updateUI();
        }
    }

    @Override
    public final void updateUI() {
        if (!this.isVisible() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DebuggerInvocationUtil.swingInvokeLater(this.myProject, () -> {
            if (!this.isValid()) {
                return;
            }
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            if (debugProcessImpl == null || !debugProcessImpl.isAttached()) {
                this.b(null);
                this.c();
            } else {
                debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (!BreakpointWithHighlighter.this.myProject.isDisposed()) {
                                BreakpointWithHighlighter.this.b(debugProcessImpl);
                            }
                        });
                        DebuggerInvocationUtil.swingInvokeLater(BreakpointWithHighlighter.this.myProject, () -> BreakpointWithHighlighter.this.c());
                    }
                });
            }
        });
    }

    private void c() {
        if (this.isVisible() && this.isValid()) {
            XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.getIcon(), this.e);
        }
    }

    public boolean isAt(@NotNull Document document, int n2) {
        if (document == null) {
            BreakpointWithHighlighter.b(6);
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        int n3 = document.getLineNumber(n2);
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null && xSourcePosition.getLine() == n3 && xSourcePosition.getFile().equals(virtualFile);
    }

    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(@Nullable SourcePosition sourcePosition) {
        return (PsiClass)ReadAction.compute(() -> JVMNameUtil.getClassAt(sourcePosition));
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    protected boolean isVisible() {
        return this.g;
    }

    public void setVisible(boolean bl2) {
        this.g = bl2;
    }

    @Nullable
    public Document getDocument() {
        PsiFile psiFile = DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject);
        if (psiFile != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
        }
        return null;
    }

    public int getLineIndex() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null ? xSourcePosition.getLine() : -1;
    }

    protected String getFileName() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        return xSourcePosition != null ? xSourcePosition.getFile().getName() : "";
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        String string;
        if (element == null) {
            BreakpointWithHighlighter.b(7);
        }
        super.readExternal(element);
        String string2 = element.getAttributeValue("class");
        if (string2 != null) {
            this.d = string2;
        }
        if ((string = element.getAttributeValue("package")) != null) {
            this.i = string;
        }
    }

    public String toString() {
        return (String)ReadAction.compute(() -> "<html><body>" + this.getDescription() + "</body>" + "</html>");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMuted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

