/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FilteredRequestorImpl
implements JDOMExternalizable,
FilteredRequestor {
    public String SUSPEND_POLICY;
    public boolean SUSPEND;
    public boolean COUNT_FILTER_ENABLED;
    public int COUNT_FILTER;
    public boolean CONDITION_ENABLED;
    private TextWithImports h;
    public boolean CLASS_FILTERS_ENABLED;
    private ClassFilter[] a;
    private ClassFilter[] f;
    public boolean INSTANCE_FILTERS_ENABLED;
    private InstanceFilter[] b;
    @NonNls
    private static final String d = "filter";
    @NonNls
    private static final String c = "exclusion_filter";
    @NonNls
    private static final String e = "instance_id";
    @NonNls
    private static final String g = "CONDITION";
    protected final Project myProject;

    public FilteredRequestorImpl(@NotNull Project project2) {
        if (project2 == null) {
            FilteredRequestorImpl.a(0);
        }
        this.SUSPEND_POLICY = "SuspendAll";
        this.SUSPEND = true;
        this.COUNT_FILTER_ENABLED = false;
        this.COUNT_FILTER = 0;
        this.CONDITION_ENABLED = false;
        this.CLASS_FILTERS_ENABLED = false;
        this.a = ClassFilter.EMPTY_ARRAY;
        this.f = ClassFilter.EMPTY_ARRAY;
        this.INSTANCE_FILTERS_ENABLED = false;
        this.b = InstanceFilter.EMPTY_ARRAY;
        this.myProject = project2;
        this.h = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return this.b;
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilterArray) {
        this.b = instanceFilterArray != null ? instanceFilterArray : InstanceFilter.EMPTY_ARRAY;
    }

    @Override
    public String getSuspendPolicy() {
        return this.SUSPEND ? this.SUSPEND_POLICY : "SuspendNone";
    }

    @Override
    public final ClassFilter[] getClassFilters() {
        return this.a;
    }

    public final void setClassFilters(ClassFilter[] classFilterArray) {
        this.a = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return this.f;
    }

    public void setClassExclusionFilters(ClassFilter[] classFilterArray) {
        this.f = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
    }

    public void readTo(Element element, Breakpoint breakpoint) throws InvalidDataException {
        this.readExternal(element);
        if (this.SUSPEND) {
            breakpoint.setSuspendPolicy(this.SUSPEND_POLICY);
        } else {
            breakpoint.setSuspendPolicy("SuspendNone");
        }
        breakpoint.setCountFilterEnabled(this.COUNT_FILTER_ENABLED);
        breakpoint.setCountFilter(this.COUNT_FILTER);
        breakpoint.setCondition(this.h);
        ((XBreakpointBase)breakpoint.myXBreakpoint).setConditionEnabled(this.CONDITION_ENABLED);
        if (this.h != null && !this.h.isEmpty()) {
            XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointCondition", TextWithImportsImpl.toXExpression(this.h));
        }
        breakpoint.setClassFiltersEnabled(this.CLASS_FILTERS_ENABLED);
        breakpoint.setClassFilters(this.getClassFilters());
        breakpoint.setClassExclusionFilters(this.getClassExclusionFilters());
        breakpoint.setInstanceFiltersEnabled(this.INSTANCE_FILTERS_ENABLED);
        breakpoint.setInstanceFilters(this.getInstanceFilters());
    }

    public void readExternal(Element element) throws InvalidDataException {
        String string;
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if ("SuspendNone".equals(this.SUSPEND_POLICY)) {
            this.SUSPEND = false;
            this.SUSPEND_POLICY = "SuspendAll";
        }
        if ((string = JDOMExternalizerUtil.readField((Element)element, (String)g)) != null) {
            this.setCondition(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string));
        }
        this.a = DebuggerUtilsEx.readFilters(element.getChildren(d));
        this.f = DebuggerUtilsEx.readFilters(element.getChildren(c));
        ClassFilter[] classFilterArray = DebuggerUtilsEx.readFilters(element.getChildren(e));
        ArrayList<InstanceFilter> arrayList = new ArrayList<InstanceFilter>(classFilterArray.length);
        for (ClassFilter classFilter : classFilterArray) {
            try {
                arrayList.add(InstanceFilter.create(classFilter));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.b = arrayList.isEmpty() ? InstanceFilter.EMPTY_ARRAY : arrayList.toArray(InstanceFilter.EMPTY_ARRAY);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        JDOMExternalizerUtil.writeField((Element)element, (String)g, (String)this.getCondition().toExternalForm());
        DebuggerUtilsEx.writeFilters(element, d, this.a);
        DebuggerUtilsEx.writeFilters(element, c, this.f);
        DebuggerUtilsEx.writeFilters(element, e, InstanceFilter.createClassFilters(this.b));
    }

    public TextWithImports getCondition() {
        return this.h;
    }

    public void setCondition(TextWithImports textWithImports) {
        this.h = textWithImports;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return this.COUNT_FILTER_ENABLED;
    }

    @Override
    public int getCountFilter() {
        return this.COUNT_FILTER;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return this.CLASS_FILTERS_ENABLED;
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return this.INSTANCE_FILTERS_ENABLED;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/FilteredRequestorImpl", "<init>"));
    }
}

