/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties>
implements JavaBreakpointType<JavaLineBreakpointProperties> {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String string, @Nls @NotNull String string2) {
        if (string == null) {
            JavaLineBreakpointType.b(0);
        }
        if (string2 == null) {
            JavaLineBreakpointType.b(1);
        }
        super(string, string2);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile virtualFile, int n2) {
        if (virtualFile == null) {
            JavaLineBreakpointType.b(2);
        }
        JavaLineBreakpointProperties javaLineBreakpointProperties = new JavaLineBreakpointProperties();
        if (javaLineBreakpointProperties == null) {
            JavaLineBreakpointType.b(3);
        }
        return javaLineBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        LineBreakpoint<JavaLineBreakpointProperties> lineBreakpoint = new LineBreakpoint<JavaLineBreakpointProperties>(project2, xBreakpoint);
        if (lineBreakpoint == null) {
            JavaLineBreakpointType.b(4);
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition xSourcePosition) {
        SourcePosition sourcePosition;
        if (project2 == null) {
            JavaLineBreakpointType.b(5);
        }
        if (xSourcePosition == null) {
            JavaLineBreakpointType.b(6);
        }
        if ((sourcePosition = DebuggerUtilsEx.toSourcePosition(xSourcePosition, project2)) == null) {
            List<JavaBreakpointVariant> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaLineBreakpointType.b(7);
            }
            return list2;
        }
        List<PsiLambdaExpression> list3 = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
        if (list3.isEmpty()) {
            List<JavaBreakpointVariant> list4 = Collections.emptyList();
            if (list4 == null) {
                JavaLineBreakpointType.b(8);
            }
            return list4;
        }
        PsiElement psiElement = DebuggerUtilsEx.getContainingMethod(sourcePosition);
        if (list3.contains(psiElement) && list3.size() == 1) {
            List<JavaBreakpointVariant> list5 = Collections.emptyList();
            if (list5 == null) {
                JavaLineBreakpointType.b(9);
            }
            return list5;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile());
        if (document == null) {
            List<JavaBreakpointVariant> list6 = Collections.emptyList();
            if (list6 == null) {
                JavaLineBreakpointType.b(10);
            }
            return list6;
        }
        SmartList smartList = new SmartList();
        if (!(psiElement instanceof PsiLambdaExpression)) {
            smartList.add(new LineJavaBreakpointVariant(xSourcePosition, psiElement, -1));
        }
        int n2 = 0;
        for (PsiLambdaExpression psiLambdaExpression : list3) {
            PsiElement psiElement2 = DebuggerUtilsEx.getFirstElementOnTheLine(psiLambdaExpression, document, xSourcePosition.getLine());
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)psiElement2);
            if (xSourcePositionImpl == null) continue;
            if (psiLambdaExpression == psiElement) {
                smartList.add(0, new LineJavaBreakpointVariant((XSourcePosition)xSourcePositionImpl, (PsiElement)psiLambdaExpression, n2++));
                continue;
            }
            smartList.add(new LambdaJavaBreakpointVariant((XSourcePosition)xSourcePositionImpl, (PsiElement)psiLambdaExpression, n2++));
        }
        smartList.add(new JavaBreakpointVariant(xSourcePosition));
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            JavaLineBreakpointType.b(11);
        }
        return smartList2;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> lineBreakpoint, @NotNull SourcePosition sourcePosition) {
        Object p2;
        if (lineBreakpoint == null) {
            JavaLineBreakpointType.b(12);
        }
        if (sourcePosition == null) {
            JavaLineBreakpointType.b(13);
        }
        if ((p2 = lineBreakpoint.getProperties()) instanceof JavaLineBreakpointProperties) {
            if (!(lineBreakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)p2)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement psiElement = this.getContainingMethod(lineBreakpoint);
            if (psiElement == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(sourcePosition, psiElement);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> lineBreakpoint) {
        Integer n2;
        SourcePosition sourcePosition;
        if (lineBreakpoint == null) {
            JavaLineBreakpointType.b(14);
        }
        if ((sourcePosition = lineBreakpoint.getSourcePosition()) == null) {
            return null;
        }
        Object p2 = lineBreakpoint.getProperties();
        if (p2 instanceof JavaLineBreakpointProperties && !(lineBreakpoint instanceof RunToCursorBreakpoint) && (n2 = ((JavaLineBreakpointProperties)((Object)p2)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> list2 = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
            if (n2 < list2.size()) {
                return (PsiElement)list2.get(n2);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(sourcePosition);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> xLineBreakpoint) {
        PsiElement psiElement;
        Breakpoint breakpoint;
        Integer n2 = JavaLineBreakpointType.a(xLineBreakpoint);
        if (n2 != null && (breakpoint = BreakpointManager.getJavaBreakpoint(xLineBreakpoint)) instanceof LineBreakpoint && (psiElement = this.getContainingMethod((LineBreakpoint)breakpoint)) != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> xBreakpoint) {
        SourcePosition sourcePosition;
        Integer n2;
        if (xBreakpoint == null) {
            JavaLineBreakpointType.b(15);
        }
        if ((n2 = JavaLineBreakpointType.a(xBreakpoint)) != null && n2 > -1 && (sourcePosition = JavaLineBreakpointType.a((XLineBreakpointImpl)xBreakpoint)) != null) {
            return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(sourcePosition, n2));
        }
        return null;
    }

    @Nullable
    private static Integer a(XBreakpoint<JavaLineBreakpointProperties> xBreakpoint) {
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)xBreakpoint.getProperties();
        return javaLineBreakpointProperties != null ? javaLineBreakpointProperties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition a(XLineBreakpointImpl xLineBreakpointImpl) {
        PsiFile psiFile;
        VirtualFile virtualFile = xLineBreakpointImpl.getFile();
        if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)xLineBreakpointImpl.getProject()).findFile(virtualFile)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)xLineBreakpointImpl.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LambdaJavaBreakpointVariant(@NotNull XSourcePosition xSourcePosition, PsiElement psiElement, Integer n2) {
            if (xSourcePosition == null) {
                LambdaJavaBreakpointVariant.c(0);
            }
            if (psiElement == null) {
                LambdaJavaBreakpointVariant.c(1);
            }
            super(xSourcePosition, psiElement, n2);
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LineJavaBreakpointVariant(@Nullable XSourcePosition xSourcePosition, PsiElement psiElement, Integer n2) {
            if (xSourcePosition == null) {
                LineJavaBreakpointVariant.c(0);
            }
            super(xSourcePosition, psiElement, n2);
        }

        @Override
        public String getText() {
            return "Line";
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        private static /* synthetic */ void c(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant", "<init>"));
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement a;
        private final Integer b;

        public ExactJavaBreakpointVariant(@Nullable XSourcePosition xSourcePosition, PsiElement psiElement, Integer n2) {
            if (xSourcePosition == null) {
                ExactJavaBreakpointVariant.b(0);
            }
            super(xSourcePosition);
            this.a = psiElement;
            this.b = n2;
        }

        public Icon getIcon() {
            return this.a != null ? this.a.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        public String getText() {
            return this.a != null ? StringUtil.shortenTextWithEllipsis((String)this.a.getText(), (int)100, (int)0) : "Line";
        }

        public TextRange getHighlightRange() {
            return this.a != null ? this.a.getTextRange() : null;
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)super.createProperties();
            assert (javaLineBreakpointProperties != null);
            javaLineBreakpointProperties.setLambdaOrdinal(this.b);
            JavaLineBreakpointProperties javaLineBreakpointProperties2 = javaLineBreakpointProperties;
            if (javaLineBreakpointProperties2 == null) {
                ExactJavaBreakpointVariant.b(1);
            }
            return javaLineBreakpointProperties2;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProperties";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        public JavaBreakpointVariant(XSourcePosition xSourcePosition) {
            if (xSourcePosition == null) {
                JavaBreakpointVariant.a(0);
            }
            super((XLineBreakpointType)JavaLineBreakpointType.this, xSourcePosition);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant", "<init>"));
        }
    }
}

