/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaLineBreakpointTypeBase<P extends JavaBreakpointProperties>
extends XLineBreakpointType<P> {
    public JavaLineBreakpointTypeBase(@NonNls @NotNull String string, @Nls @NotNull String string2) {
        if (string == null) {
            JavaLineBreakpointTypeBase.a(0);
        }
        if (string2 == null) {
            JavaLineBreakpointTypeBase.a(1);
        }
        super(string, string2);
    }

    public final boolean isSuspendThreadSupported() {
        return true;
    }

    @Nullable
    public final XBreakpointCustomPropertiesPanel<XLineBreakpoint<P>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            JavaLineBreakpointTypeBase.a(2);
        }
        return new JavaBreakpointFiltersPanel(project2);
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<P> xLineBreakpoint, @NotNull Project project2) {
        if (xLineBreakpoint == null) {
            JavaLineBreakpointTypeBase.a(3);
        }
        if (project2 == null) {
            JavaLineBreakpointTypeBase.a(4);
        }
        return new JavaDebuggerEditorsProvider();
    }

    public String getDisplayText(XLineBreakpoint<P> xLineBreakpoint) {
        BreakpointWithHighlighter breakpointWithHighlighter = (BreakpointWithHighlighter)BreakpointManager.getJavaBreakpoint(xLineBreakpoint);
        if (breakpointWithHighlighter != null) {
            return breakpointWithHighlighter.getDescription();
        }
        return super.getDisplayText(xLineBreakpoint);
    }

    public boolean canPutAt(@NotNull VirtualFile virtualFile, int n2, @NotNull Project project2) {
        PsiFile psiFile;
        if (virtualFile == null) {
            JavaLineBreakpointTypeBase.a(5);
        }
        if (project2 == null) {
            JavaLineBreakpointTypeBase.a(6);
        }
        if ((psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile)) == null || psiFile.getViewProvider().getFileType() == StdFileTypes.XHTML) {
            return false;
        }
        if (!StdFileTypes.CLASS.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return false;
        }
        Ref ref = Ref.create();
        XDebuggerUtil.getInstance().iterateLine(project2, document, n2, psiElement -> {
            if (psiElement instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiComment.class, PsiImportStatementBase.class, PsiPackageStatement.class}) != null) {
                return true;
            }
            PsiElement psiElement2 = psiElement;
            while (psiElement != null) {
                if (psiElement instanceof PsiModifierList) {
                    psiElement = psiElement.getParent();
                    continue;
                }
                int n3 = psiElement.getTextOffset();
                if (n3 >= 0 && document.getLineNumber(n3) != n2) break;
                psiElement2 = psiElement;
                psiElement = psiElement.getParent();
            }
            if (psiElement2 instanceof PsiMethod) {
                PsiStatement[] psiStatementArray;
                PsiCodeBlock psiCodeBlock;
                if (psiElement2.getTextRange().getEndOffset() >= document.getLineEndOffset(n2) && (psiCodeBlock = ((PsiMethod)psiElement2).getBody()) != null && (psiStatementArray = psiCodeBlock.getStatements()).length > 0 && document.getLineNumber(psiStatementArray[0].getTextOffset()) == n2) {
                    ref.set(JavaLineBreakpointType.class);
                }
                if (ref.isNull()) {
                    ref.set(JavaMethodBreakpointType.class);
                }
            } else if (psiElement2 instanceof PsiField) {
                if (ref.isNull()) {
                    ref.set(JavaFieldBreakpointType.class);
                }
            } else {
                ref.set(JavaLineBreakpointType.class);
            }
            return true;
        });
        return ref.get() == ((Object)((Object)this)).getClass();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointTypeBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomRightPropertiesPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

