/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    private static final Logger k = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.LineBreakpoint");
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");
    private static final Pattern j = Pattern.compile(".*\\$\\d*$");

    protected LineBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    protected Icon getDisabledIcon(boolean bl2) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null) {
            return bl2 ? AllIcons.Debugger.Db_muted_dep_line_breakpoint : AllIcons.Debugger.Db_dep_line_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getInvalidIcon(boolean bl2) {
        return bl2 ? AllIcons.Debugger.Db_muted_invalid_breakpoint : AllIcons.Debugger.Db_invalid_breakpoint;
    }

    @Override
    protected Icon getVerifiedIcon(boolean bl2) {
        if (this.isRemoveAfterHit()) {
            return bl2 ? AllIcons.Debugger.Db_muted_temporary_breakpoint : AllIcons.Debugger.Db_temporary_breakpoint;
        }
        return bl2 ? AllIcons.Debugger.Db_muted_verified_breakpoint : AllIcons.Debugger.Db_verified_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean bl2) {
        return bl2 ? AllIcons.Debugger.Db_muted_verified_warning_breakpoint : AllIcons.Debugger.Db_verified_warning_breakpoint;
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcessImpl, String string) {
        if (this.a(debugProcessImpl, string)) {
            super.createOrWaitPrepare(debugProcessImpl, string);
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
        if (!this.a(debugProcessImpl, referenceType.name())) {
            if (k.isDebugEnabled()) {
                k.debug(referenceType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List<Location> list2 = debugProcessImpl.getPositionManager().locationsOfLine(referenceType, this.getSourcePosition());
            if (!list2.isEmpty()) {
                for (Location location : list2) {
                    if (k.isDebugEnabled()) {
                        k.debug("Found location [codeIndex=" + location.codeIndex() + "] for reference type " + referenceType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcessImpl.getVirtualMachineProxy().versionHigher("1.4") && location.method().isObsolete()));
                    }
                    if (!this.acceptLocation(debugProcessImpl, referenceType, location)) continue;
                    LineBreakpoint.createLocationBreakpointRequest(this, location, debugProcessImpl);
                    if (!k.isDebugEnabled()) continue;
                    k.debug("Created breakpoint request for reference type " + referenceType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + location.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations(referenceType) == null) {
                debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{referenceType.name()}));
                if (k.isDebugEnabled()) {
                    k.debug("No line number info in " + referenceType.name());
                }
            } else {
                debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, referenceType.name()}));
                if (k.isDebugEnabled()) {
                    k.debug("No locations of type " + referenceType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            if (k.isDebugEnabled()) {
                k.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            if (k.isDebugEnabled()) {
                k.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
            }
        }
        catch (InvalidLineNumberException invalidLineNumberException) {
            if (k.isDebugEnabled()) {
                k.debug("InvalidLineNumberException: " + invalidLineNumberException.getMessage());
            }
            debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.bad.line.number", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            k.info((Throwable)exception);
        }
        this.updateUI();
    }

    private static boolean a(ReferenceType referenceType) {
        if (referenceType instanceof ClassType) {
            return j.matcher(referenceType.name()).matches();
        }
        return false;
    }

    protected boolean acceptLocation(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, Location location) {
        Method method = location.method();
        if (LineBreakpoint.a(referenceType) && (method.isConstructor() && location.codeIndex() == 0L || method.isBridge())) {
            return false;
        }
        SourcePosition sourcePosition = debugProcessImpl.getPositionManager().getSourcePosition(location);
        if (sourcePosition == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            JavaLineBreakpointType javaLineBreakpointType = this.getXBreakpointType();
            if (javaLineBreakpointType == null) {
                return true;
            }
            return javaLineBreakpointType.matchesPosition(this, sourcePosition);
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType xBreakpointType = this.myXBreakpoint.getType();
        if (xBreakpointType instanceof JavaLineBreakpointType) {
            return (JavaLineBreakpointType)xBreakpointType;
        }
        return null;
    }

    private boolean a(DebugProcessImpl debugProcessImpl, String string) {
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null) {
            VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (virtualFile != null && projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcessImpl.getSearchScope().contains(virtualFile)) {
                    return true;
                }
                Collection<VirtualFile> collection = this.b(string, debugProcessImpl.getSearchScope(), projectFileIndex);
                if (k.isDebugEnabled()) {
                    k.debug("Found " + (collection == null ? "null" : Integer.valueOf(collection.size())) + " candidate containing files for class " + string);
                }
                if (collection == null) {
                    return true;
                }
                if (k.isDebugEnabled()) {
                    GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
                    boolean bl2 = globalSearchScope.contains(virtualFile);
                    List list2 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, globalSearchScope), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    List list3 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    VirtualFile virtualFile2 = projectFileIndex.getContentRootForFile(virtualFile);
                    Module module2 = projectFileIndex.getModuleForFile(virtualFile);
                    k.debug("Did not find '" + string + "' in " + globalSearchScope + "; contains=" + bl2 + "; contentRoot=" + virtualFile2 + "; module = " + module2 + "; all files in index are: " + list2 + "; all possible files are: " + list3);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> b(String string, GlobalSearchScope globalSearchScope, ProjectFileIndex projectFileIndex) {
        int n2 = string.indexOf("$");
        String string2 = n2 >= 0 ? string.substring(0, n2) : string;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] psiClassArray = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string2, globalSearchScope);
            if (k.isDebugEnabled()) {
                k.debug("Found " + psiClassArray.length + " classes " + string2 + " in scope " + globalSearchScope);
            }
            if (psiClassArray.length == 0) {
                return null;
            }
            ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(psiClassArray.length);
            for (PsiClass psiClass : psiClassArray) {
                StringBuilder stringBuilder;
                PsiFile psiFile = psiClass.getContainingFile();
                if (k.isDebugEnabled()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Checking class ").append(psiClass.getQualifiedName());
                    stringBuilder.append("\n\t").append("PsiFile=").append(psiFile);
                    if (psiFile != null) {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        stringBuilder.append("\n\t").append("VirtualFile=").append(virtualFile);
                        if (virtualFile != null) {
                            stringBuilder.append("\n\t").append("isInSourceContent=").append(projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    k.debug(stringBuilder.toString());
                }
                if (psiFile == null) {
                    return null;
                }
                stringBuilder = psiFile.getVirtualFile();
                if (stringBuilder == null || !projectFileIndex.isUnderSourceRootOfType((VirtualFile)stringBuilder, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                arrayList.add(stringBuilder);
            }
            return arrayList;
        });
    }

    @Override
    protected String calculateEventClass(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        String string = null;
        ObjectReference objectReference = (ObjectReference)evaluationContextImpl.computeThisObject();
        if (objectReference != null) {
            string = objectReference.referenceType().name();
        } else {
            StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl.getFrameProxy();
            if (stackFrameProxyImpl != null) {
                string = stackFrameProxyImpl.location().declaringType().name();
            }
        }
        return string;
    }

    @Override
    public String getShortName() {
        return this.a(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.a(true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(boolean bl2, int n2) {
        if (this.isValid()) {
            boolean bl3;
            int n3 = this.myXBreakpoint.getSourcePosition().getLine() + 1;
            String string = this.getClassName();
            boolean bl4 = string != null && string.length() > 0;
            String string2 = this.getMethodName();
            String string3 = string2 != null ? string2 + "()" : null;
            boolean bl5 = bl3 = string3 != null && string3.length() > 0;
            if (bl4 || bl3) {
                StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
                try {
                    boolean bl6 = this.myXBreakpoint.getSourcePosition().getFile().getName().equals(string);
                    String string4 = null;
                    if (bl4) {
                        int n4;
                        int n5 = string.lastIndexOf(".");
                        if (n5 >= 0 && !bl6) {
                            string4 = string.substring(0, n5);
                            string = string.substring(n5 + 1);
                        }
                        if (n2 != -1 && string.length() + (bl3 ? string3.length() : 0) > n2 + 3 && (n4 = n2 - (bl3 ? string3.length() : 0)) > 0 && n4 < string.length()) {
                            string = string.substring(string.length() - n4);
                            stringBuilder.append("...");
                        }
                        stringBuilder.append(string);
                    }
                    if (bl3) {
                        if (bl6) {
                            stringBuilder.append(":");
                        } else if (bl4) {
                            stringBuilder.append(".");
                        }
                        stringBuilder.append(string3);
                    }
                    if (bl2 && string4 != null) {
                        stringBuilder.append(" (").append(string4).append(")");
                    }
                    String string5 = DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{n3, stringBuilder.toString()});
                    return string5;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
                }
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{n3});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String b(PsiFile psiFile, int n2) {
        if (n2 < 0 || psiFile instanceof JspFile) {
            return null;
        }
        if (psiFile instanceof PsiClassOwner) {
            return (String)ReadAction.compute(() -> {
                PsiMethod psiMethod = DebuggerUtilsEx.findPsiMethod(psiFile, n2);
                return psiMethod != null ? psiMethod.getName() : null;
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent locatableEvent) {
        Location location = locatableEvent.location();
        String string = DebuggerUtilsEx.getSourceName(location, throwable -> this.getFileName());
        return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), string, this.getLineIndex() + 1});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            LineBreakpoint.c(0);
        }
        LineBreakpoint lineBreakpoint = new LineBreakpoint(project2, xBreakpoint);
        return (LineBreakpoint)lineBreakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project2, Document document, int n2) {
        if (n2 < 0 || n2 >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        LineBreakpoint lineBreakpoint = breakpointManager.findBreakpoint(document, document.getLineStartOffset(n2), CATEGORY);
        if (lineBreakpoint != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        boolean[] blArray = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project2, document, n2, psiElement -> {
            PsiStatement[] psiStatementArray;
            PsiCodeBlock psiCodeBlock;
            int n3;
            if (psiElement instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            PsiElement psiElement2 = psiElement;
            while (psiElement != null && ((n3 = psiElement.getTextOffset()) < 0 || document.getLineNumber(n3) == n2)) {
                psiElement2 = psiElement;
                psiElement = psiElement.getParent();
            }
            blArray[0] = psiElement2 instanceof PsiMethod && psiElement2.getTextRange().getEndOffset() >= document.getLineEndOffset(n2) ? ((psiCodeBlock = ((PsiMethod)psiElement2).getBody()) == null ? false : (psiStatementArray = psiCodeBlock.getStatements()).length > 0 && document.getLineNumber(psiStatementArray[0].getTextOffset()) == n2) : true;
            return false;
        });
        return blArray[0];
    }

    @Nullable
    public String getMethodName() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        if (xSourcePosition != null) {
            int n2 = xSourcePosition.getOffset();
            return LineBreakpoint.b(DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject), n2);
        }
        return null;
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
    }
}

