/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepIntoBreakpoint
extends RunToCursorBreakpoint {
    private static final Logger p = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint");
    @NotNull
    private final BreakpointStepMethodFilter q;
    @Nullable
    private RequestHint o;

    protected StepIntoBreakpoint(@NotNull Project project2, @NotNull SourcePosition sourcePosition, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        if (project2 == null) {
            StepIntoBreakpoint.f(0);
        }
        if (sourcePosition == null) {
            StepIntoBreakpoint.f(1);
        }
        if (breakpointStepMethodFilter == null) {
            StepIntoBreakpoint.f(2);
        }
        super(project2, sourcePosition, false);
        this.q = breakpointStepMethodFilter;
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
        try {
            int n2;
            CompoundPositionManager compoundPositionManager = debugProcessImpl.getPositionManager();
            List<Location> list2 = compoundPositionManager.locationsOfLine(referenceType, this.myCustomPosition);
            if (list2.isEmpty() && (n2 = this.q.getLastStatementLine()) >= 0) {
                int n3 = this.myCustomPosition.getLine() + 1;
                while (n3 <= n2 && list2.isEmpty()) {
                    list2 = compoundPositionManager.locationsOfLine(referenceType, SourcePosition.createFromLine((PsiFile)this.myCustomPosition.getFile(), (int)n3++));
                }
            }
            if (!list2.isEmpty()) {
                MultiMap multiMap = new MultiMap();
                for (Location location : list2) {
                    if (!this.acceptLocation(debugProcessImpl, referenceType, location)) continue;
                    multiMap.putValue((Object)location.method(), (Object)location);
                }
                Object object = null;
                int n4 = multiMap.size();
                if (n4 == 1) {
                    object = (Location)multiMap.values().iterator().next();
                } else if (this.q instanceof LambdaMethodFilter) {
                    LambdaMethodFilter lambdaMethodFilter = (LambdaMethodFilter)this.q;
                    if (lambdaMethodFilter.getLambdaOrdinal() < n4) {
                        Method[] methodArray = multiMap.keySet().toArray(new Method[n4]);
                        Arrays.sort(methodArray, DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
                        object = (Location)multiMap.get((Object)methodArray[lambdaMethodFilter.getLambdaOrdinal()]).iterator().next();
                    }
                } else if (n4 > 0) {
                    object = (Location)multiMap.values().iterator().next();
                }
                StepIntoBreakpoint.createLocationBreakpointRequest(this, (Location)object, debugProcessImpl);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            if (p.isDebugEnabled()) {
                p.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            if (p.isDebugEnabled()) {
                p.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
            }
        }
        catch (Exception exception) {
            p.info((Throwable)exception);
        }
    }

    @Override
    protected boolean acceptLocation(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, Location location) {
        try {
            return this.q.locationMatches(debugProcessImpl, location);
        }
        catch (EvaluateException evaluateException) {
            p.info((Throwable)evaluateException);
            return true;
        }
    }

    @Nullable
    protected static StepIntoBreakpoint create(@NotNull Project project2, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        SourcePosition sourcePosition;
        if (project2 == null) {
            StepIntoBreakpoint.f(3);
        }
        if (breakpointStepMethodFilter == null) {
            StepIntoBreakpoint.f(4);
        }
        if ((sourcePosition = breakpointStepMethodFilter.getBreakpointPosition()) != null) {
            StepIntoBreakpoint stepIntoBreakpoint = new StepIntoBreakpoint(project2, sourcePosition, breakpointStepMethodFilter);
            stepIntoBreakpoint.init();
            return stepIntoBreakpoint;
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl suspendContextImpl;
        boolean bl2 = super.processLocatableEvent(suspendContextCommandImpl, locatableEvent);
        if (bl2 && this.o != null && this.o.isResetIgnoreFilters() && (suspendContextImpl = suspendContextCommandImpl.getSuspendContext()) != null) {
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            debugProcessImpl.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list2 -> debugProcessImpl.getSession().resetIgnoreStepFiltersFlag()));
        }
        return bl2;
    }

    public void setRequestHint(RequestHint requestHint) {
        this.o = requestHint;
    }

    private static /* synthetic */ void f(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

