/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TipManager
implements Disposable,
PopupMenuListener {
    private volatile boolean f = false;
    private boolean g;
    private MyAwtPreprocessor h;
    private MouseEvent i;
    boolean myInsideComponent;
    private JComponent n;
    private Popup a;
    private final TipFactory b;
    private final JComponent l;
    private MouseListener j = new MyMouseListener();
    private MouseMotionListener k = new MyMouseMotionListener();
    private FrameStateListener e = new MyFrameStateListener();
    private final Alarm m = new Alarm();
    private final Alarm c = new Alarm();
    private IdeGlassPane d;

    private boolean b(MouseEvent mouseEvent) {
        if (this.n != null) {
            if (!this.n.isShowing()) {
                this.hideTooltip(true);
                return false;
            }
            Component component = mouseEvent.getComponent();
            if (component == null) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, component);
            Rectangle rectangle = this.n.getBounds();
            Point point2 = this.n.getLocationOnScreen();
            rectangle.setLocation(point2.x, point2.y);
            return rectangle.contains(point);
        }
        return false;
    }

    public JPopupMenu registerPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.addPopupMenuListener(this);
        return jPopupMenu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.g = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.a(popupMenuEvent);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.a(popupMenuEvent);
    }

    private void a(PopupMenuEvent popupMenuEvent) {
        this.g = false;
        if (popupMenuEvent.getSource() instanceof JPopupMenu) {
            ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        }
    }

    private boolean a(MouseEvent mouseEvent) {
        Rectangle rectangle = this.l.getVisibleRect();
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.l);
        return rectangle.contains(point);
    }

    private void c(InputEvent inputEvent, boolean bl2) {
        this.m.cancelAllRequests();
        this.c.cancelAllRequests();
        this.m.addRequest(() -> {
            if (!this.f && !this.g) {
                this.a(inputEvent, bl2);
            }
        }, bl2 ? XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay() : 10);
    }

    private void a(InputEvent inputEvent, boolean bl2) {
        if (bl2 && !Registry.is((String)"debugger.valueTooltipAutoShow")) {
            return;
        }
        MouseEvent mouseEvent = null;
        JComponent jComponent = null;
        if (inputEvent instanceof MouseEvent) {
            mouseEvent = (MouseEvent)inputEvent;
        } else if (inputEvent instanceof KeyEvent) {
            mouseEvent = this.b.createTooltipEvent(this.i);
        }
        MouseEvent mouseEvent2 = null;
        if (mouseEvent != null) {
            mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.l);
            jComponent = this.b.createToolTip(mouseEvent2);
        }
        if (jComponent == null || bl2 && !this.b.isFocusOwner()) {
            this.hideTooltip(false);
            return;
        }
        if (jComponent == this.n) {
            if (!bl2) {
                this.hideTooltip(true);
                return;
            }
            return;
        }
        this.hideTooltip(true);
        if (this.l.isShowing()) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point point = mouseEvent2.getPoint();
            Component component = mouseEvent2.getComponent();
            if (component != null) {
                SwingUtilities.convertPointToScreen(point, component);
            }
            this.a = popupFactory.getPopup(this.l, jComponent, point.x, point.y);
            this.myInsideComponent = false;
            this.a.show();
            this.n = jComponent;
        }
    }

    public void hideTooltip() {
        this.hideTooltip(true);
    }

    public void hideTooltip(boolean bl2) {
        if (this.a == null) {
            return;
        }
        if (bl2) {
            this.c.cancelAllRequests();
            this.a.hide();
            this.a = null;
            this.n = null;
        } else {
            this.c.addRequest(() -> {
                if (this.myInsideComponent) {
                    this.hideTooltip(true);
                }
            }, 100);
        }
    }

    public TipManager(JComponent jComponent, TipFactory tipFactory) {
        this.b = tipFactory;
        this.l = jComponent;
        new UiNotifyConnector.Once((Component)jComponent, new Activatable(){

            public void showNotify() {
                TipManager.this.a();
            }

            public void hideNotify() {
            }
        });
        final HideTooltipAction hideTooltipAction = new HideTooltipAction();
        hideTooltipAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.l);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                hideTooltipAction.unregisterCustomShortcutSet(TipManager.this.l);
            }
        });
    }

    private void a() {
        if (this.f) {
            return;
        }
        this.d = IdeGlassPaneUtil.find((Component)this.l);
        assert (this.d != null);
        this.d.addMousePreprocessor(this.j, (Disposable)this);
        this.d.addMouseMotionPreprocessor(this.k, (Disposable)this);
        this.h = new MyAwtPreprocessor();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.h, 56L);
        FrameStateManager.getInstance().addListener(this.e);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.hideTooltip(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.h);
        this.f = true;
        this.m.cancelAllRequests();
        this.j = null;
        this.k = null;
        FrameStateManager.getInstance().removeListener(this.e);
        this.e = null;
    }

    private class MyAwtPreprocessor
    implements AWTEventListener {
        private MyAwtPreprocessor() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 503) {
                this.a(aWTEvent);
            } else if (aWTEvent.getID() == 501 || aWTEvent.getID() == 502) {
                this.a((MouseEvent)aWTEvent);
            } else if (aWTEvent instanceof KeyEvent) {
                this.a((KeyEvent)aWTEvent);
            }
        }

        private void a(MouseEvent mouseEvent) {
            if (TipManager.this.n == null) {
                return;
            }
            if (this.b(mouseEvent) && UIUtil.isCloseClick((MouseEvent)mouseEvent)) {
                TipManager.this.hideTooltip(true);
            }
        }

        private void a(KeyEvent keyEvent) {
            if (KeymapUtil.isTooltipRequest((KeyEvent)keyEvent)) {
                TipManager.this.c(keyEvent, false);
            } else if (keyEvent.getID() == 401) {
                TipManager.this.i = null;
            }
        }

        private void a(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (TipManager.this.n == null) {
                return;
            }
            if (aWTEvent.getID() == 503 && this.b(mouseEvent = (MouseEvent)aWTEvent)) {
                TipManager.this.c.cancelAllRequests();
            }
        }

        private boolean b(MouseEvent mouseEvent) {
            return TipManager.this.n == mouseEvent.getComponent() || SwingUtilities.isDescendingFrom(mouseEvent.getComponent(), TipManager.this.n);
        }
    }

    private class HideTooltipAction
    extends AnAction {
        private HideTooltipAction() {
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            TipManager.this.hideTooltip(true);
        }

        public void update(AnActionEvent anActionEvent) {
            anActionEvent.getPresentation().setEnabled(TipManager.this.a != null);
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter
    implements Weighted {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TipManager.this.i = mouseEvent;
            if (!TipManager.this.l.isShowing()) {
                return;
            }
            TipManager.this.myInsideComponent = true;
            if (TipManager.this.n == null) {
                if (TipManager.this.a(mouseEvent)) {
                    TipManager.this.c(mouseEvent, true);
                }
            } else if (!TipManager.this.b(mouseEvent)) {
                TipManager.this.c(mouseEvent, true);
            }
        }

        public double getWeight() {
            return 0.0;
        }
    }

    private class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private MyFrameStateListener() {
        }

        public void onFrameDeactivated() {
            TipManager.this.hideTooltip(true);
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements Weighted {
        private MyMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TipManager.this.myInsideComponent = false;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TipManager.this.myInsideComponent) {
                TipManager.this.hideTooltip(true);
            }
        }

        public double getWeight() {
            return 0.0;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TipManager.this.myInsideComponent = true;
        }
    }

    public static interface TipFactory {
        public JComponent createToolTip(MouseEvent var1);

        public MouseEvent createTooltipEvent(MouseEvent var1);

        public boolean isFocusOwner();
    }
}

