/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class CompilingEvaluator
implements ExpressionEvaluator {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiElement myPsiContext;
    @NotNull
    protected final ExtractLightMethodObjectHandler.ExtractedData myData;
    private static final String a = "GeneratedEvaluationClass";

    public CompilingEvaluator(@NotNull Project project2, @NotNull PsiElement psiElement, @NotNull ExtractLightMethodObjectHandler.ExtractedData extractedData) {
        if (project2 == null) {
            CompilingEvaluator.a(0);
        }
        if (psiElement == null) {
            CompilingEvaluator.a(1);
        }
        if (extractedData == null) {
            CompilingEvaluator.a(2);
        }
        this.myProject = project2;
        this.myPsiContext = psiElement;
        this.myData = extractedData;
    }

    public Modifier getModifier() {
        return null;
    }

    private TextWithImports a() {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, this.myData.getGeneratedCallText());
    }

    public Value evaluate(EvaluationContext evaluationContext) throws EvaluateException {
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        EvaluationContextImpl evaluationContextImpl = ((EvaluationContextImpl)evaluationContext).withAutoLoadClasses(true);
        ClassLoaderReference classLoaderReference = ClassLoadingUtils.getClassLoader(evaluationContextImpl, debugProcess);
        evaluationContextImpl.setClassLoader(classLoaderReference);
        JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromVersionString((String)((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).version());
        Collection<ClassObject> collection = this.compile(javaSdkVersion);
        this.a(javaSdkVersion, collection, evaluationContextImpl, debugProcess, classLoaderReference);
        try {
            ExpressionEvaluator expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    TextWithImports textWithImports = CompilingEvaluator.this.a();
                    PsiElement psiElement = CompilingEvaluator.this.myData.getAnchor();
                    CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement);
                    return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)codeFragmentFactory.createCodeFragment(textWithImports, psiElement, CompilingEvaluator.this.myProject), SourcePosition.createFromElement((PsiElement)psiElement));
                }
            });
            return expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
        }
        catch (Exception exception) {
            throw new EvaluateException("Error during generated code invocation " + exception, (Throwable)exception);
        }
    }

    private void a(JavaSdkVersion javaSdkVersion, Collection<ClassObject> collection, EvaluationContext evaluationContext, DebugProcess debugProcess, ClassLoaderReference classLoaderReference) throws EvaluateException {
        boolean bl2 = javaSdkVersion != null && !javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_9);
        for (ClassObject classObject : collection) {
            byte[] byArray;
            if (!classObject.getPath().contains(a) || (byArray = classObject.getContent()) == null) continue;
            if (bl2) {
                byArray = CompilingEvaluator.a(byArray);
            }
            ClassLoadingUtils.defineClass(classObject.getClassName(), byArray, evaluationContext, debugProcess, classLoaderReference);
        }
        debugProcess.findClass(evaluationContext, this.getGenClassQName(), classLoaderReference);
    }

    private static byte[] a(byte[] byArray) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(393216, (ClassVisitor)classWriter){

            public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
                if ("java/lang/Object".equals(string3)) {
                    string3 = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(n2, n3, string, string2, string3, stringArray);
            }
        };
        new ClassReader(byArray).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    public static String getGeneratedClassName() {
        return a;
    }

    protected String getGenClassQName() {
        return (String)ReadAction.compute(() -> JVMNameUtil.getNonAnonymousClassName(this.myData.getGeneratedInnerClass()));
    }

    @NotNull
    protected abstract Collection<ClassObject> compile(@Nullable JavaSdkVersion var1) throws EvaluateException;

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

