/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeNodeExpression {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression");
    public static final Key<Set<String>> ADDITIONAL_IMPORTS_KEY = Key.create((String)"ADDITIONAL_IMPORTS");

    private static boolean a(PsiMethod psiMethod, PsiMethod psiMethod2) {
        PsiMethod[] psiMethodArray;
        for (PsiMethod psiMethod3 : psiMethodArray = psiMethod2.findSuperMethods()) {
            if (psiMethod3 != psiMethod && !DebuggerTreeNodeExpression.a(psiMethod, psiMethod3)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiExpression substituteThis(@Nullable PsiElement psiElement, PsiExpression psiExpression, Value value) throws EvaluateException {
        PsiClass psiClass;
        PsiType psiType;
        if (!(psiElement instanceof PsiExpression)) {
            return null;
        }
        PsiExpression psiExpression2 = (PsiExpression)psiElement.copy();
        PsiClass psiClass2 = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiExpression2, PsiClass.class, (boolean)true);
        boolean bl2 = true;
        if (psiClass2 != null && (psiType = psiExpression.getType()) != null) {
            if (psiType instanceof PsiClassType) {
                psiClass = ((PsiClassType)psiType).resolve();
                if (psiClass != null && (psiClass == psiClass2 || psiClass.isInheritor(psiClass2, true))) {
                    bl2 = false;
                }
            } else if (psiType instanceof PsiArrayType) {
                psiClass = PsiUtil.getLanguageLevel((PsiElement)psiElement);
                if (psiClass2 == JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().getArrayClass((LanguageLevel)psiClass)) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            psiExpression = DebuggerTreeNodeExpression.castToRuntimeType(psiExpression, value);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)psiExpression2, (boolean)false);
        try {
            psiType = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)psiExpression2, (PsiClass)psiClass2, (PsiExpression)psiExpression);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.this.expression", (Object[])new Object[]{psiExpression2.getText(), psiExpression.getText()}), null);
        }
        try {
            psiClass = JavaPsiFacade.getInstance((Project)psiExpression.getProject()).getElementFactory().createExpressionFromText(psiType.getText(), psiExpression.getContext());
            psiClass.putUserData(ADDITIONAL_IMPORTS_KEY, psiExpression.getUserData(ADDITIONAL_IMPORTS_KEY));
            return psiClass;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(incorrectOperationException.getMessage(), (Throwable)incorrectOperationException);
        }
    }

    public static PsiExpression castToRuntimeType(PsiExpression psiExpression, Value value) throws EvaluateException {
        if (!(value instanceof ObjectReference)) {
            return psiExpression;
        }
        ReferenceType referenceType = ((ObjectReference)value).referenceType();
        if (referenceType == null) {
            return psiExpression;
        }
        Project project2 = psiExpression.getProject();
        PsiType psiType = RuntimeTypeEvaluator.getCastableRuntimeType(project2, value);
        if (psiType == null) {
            return psiExpression;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String string = psiType.getCanonicalText();
        try {
            PsiParenthesizedExpression psiParenthesizedExpression = (PsiParenthesizedExpression)psiElementFactory.createExpressionFromText("((" + string + ")expression)", null);
            ((PsiTypeCastExpression)psiParenthesizedExpression.getExpression()).getOperand().replace((PsiElement)psiExpression);
            Set set = (Set)psiExpression.getUserData(ADDITIONAL_IMPORTS_KEY);
            if (set == null) {
                set = new SmartHashSet();
            }
            set.add(string);
            psiParenthesizedExpression.putUserData(ADDITIONAL_IMPORTS_KEY, (Object)set);
            return psiParenthesizedExpression;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.type.name", (Object[])new Object[]{string}), (Throwable)incorrectOperationException);
        }
    }

    public static String normalize(String string, PsiElement psiElement, Project project2) {
        if (psiElement == null) {
            return string;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass psiClass = javaPsiFacade.findClass(string, GlobalSearchScope.allScope((Project)project2));
        if (psiClass != null) {
            return DebuggerTreeNodeExpression.a(psiClass, psiElement, javaPsiFacade.getResolveHelper());
        }
        return string;
    }

    private static String a(PsiClass psiClass, PsiElement psiElement, PsiResolveHelper psiResolveHelper) {
        String string = psiClass.getName();
        PsiClass psiClass2 = psiResolveHelper.resolveReferencedClass(string, psiElement);
        if (psiClass.equals(psiClass2)) {
            return string;
        }
        PsiClass psiClass3 = psiClass.getContainingClass();
        if (psiClass3 != null) {
            return DebuggerTreeNodeExpression.a(psiClass3, psiElement, psiResolveHelper) + "." + string;
        }
        return psiClass.getQualifiedName();
    }

    public static PsiExpression getEvaluationExpression(DebuggerTreeNodeImpl debuggerTreeNodeImpl, DebuggerContextImpl debuggerContextImpl) throws EvaluateException {
        if (debuggerTreeNodeImpl.getDescriptor() instanceof ValueDescriptorImpl) {
            throw new IllegalStateException("Not supported any more");
        }
        a.error(debuggerTreeNodeImpl.getDescriptor() != null ? debuggerTreeNodeImpl.getDescriptor().getClass().getName() : "null");
        return null;
    }

    public static TextWithImports createEvaluationText(DebuggerTreeNodeImpl debuggerTreeNodeImpl, DebuggerContextImpl debuggerContextImpl) throws EvaluateException {
        EvaluateException[] evaluateExceptionArray = new EvaluateException[]{null};
        TextWithImports textWithImports = (TextWithImports)PsiDocumentManager.getInstance((Project)debuggerContextImpl.getProject()).commitAndRunReadAction(() -> {
            try {
                PsiExpression psiExpression = DebuggerTreeNodeExpression.getEvaluationExpression(debuggerTreeNodeImpl, debuggerContextImpl);
                if (psiExpression != null) {
                    return new TextWithImportsImpl((PsiElement)psiExpression);
                }
            }
            catch (EvaluateException evaluateException) {
                evaluateExceptionArray[0] = evaluateException;
            }
            return null;
        });
        if (evaluateExceptionArray[0] != null) {
            throw evaluateExceptionArray[0];
        }
        return textWithImports;
    }

    private static class IncorrectOperationRuntimeException
    extends RuntimeException {
        private final IncorrectOperationException a;

        public IncorrectOperationRuntimeException(IncorrectOperationException incorrectOperationException) {
            this.a = incorrectOperationException;
        }

        public IncorrectOperationException getException() {
            return this.a;
        }
    }
}

