/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDescriptorImpl
extends ValueDescriptorImpl
implements LocalVariableDescriptor {
    private final StackFrameProxyImpl t;
    private final LocalVariableProxyImpl s;
    private String q;
    private boolean p;
    private boolean r;

    public LocalVariableDescriptorImpl(Project project2, @NotNull LocalVariableProxyImpl localVariableProxyImpl) {
        if (localVariableProxyImpl == null) {
            LocalVariableDescriptorImpl.b(0);
        }
        super(project2);
        this.q = DebuggerBundle.message((String)"label.unknown.value", (Object[])new Object[0]);
        this.r = true;
        this.setLvalue(true);
        this.t = localVariableProxyImpl.getFrame();
        this.s = localVariableProxyImpl;
    }

    @Override
    public LocalVariableProxyImpl getLocalVariable() {
        return this.s;
    }

    public boolean isNewLocal() {
        return this.r;
    }

    @Override
    public boolean isPrimitive() {
        return this.p;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        boolean bl2 = this.t.isLocalVariableVisible(this.getLocalVariable());
        if (bl2) {
            String string;
            this.q = string = this.getLocalVariable().typeName();
            this.p = DebuggerUtils.isPrimitiveType((String)string);
            return this.t.getValue(this.getLocalVariable());
        }
        return null;
    }

    public void setNewLocal(boolean bl2) {
        this.r = bl2;
    }

    @Override
    public void displayAs(NodeDescriptor nodeDescriptor) {
        super.displayAs(nodeDescriptor);
        if (nodeDescriptor instanceof LocalVariableDescriptorImpl) {
            this.r = ((LocalVariableDescriptorImpl)nodeDescriptor).r;
        }
    }

    @Override
    public String getName() {
        return this.s.name();
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.q;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return psiElementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)debuggerContext));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                LocalVariableProxyImpl localVariableProxyImpl;
                if (xExpression == null) {
                    1.b(0);
                }
                if (xModificationCallback == null) {
                    1.b(1);
                }
                if ((localVariableProxyImpl = LocalVariableDescriptorImpl.this.getLocalVariable()) != null) {
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(LocalVariableDescriptorImpl.this.getProject()).getContext();
                    this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            debuggerContextImpl.getFrameProxy().setValue(localVariableProxyImpl, 1.preprocessValue(evaluationContextImpl, value, localVariableProxyImpl.getType()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
                        }
                    });
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl", "<init>"));
    }
}

