/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.descriptors.data.ArgValueData;
import com.intellij.debugger.impl.descriptors.data.ArrayItemData;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DescriptorKey;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.FieldData;
import com.intellij.debugger.impl.descriptors.data.LocalData;
import com.intellij.debugger.impl.descriptors.data.MethodReturnValueData;
import com.intellij.debugger.impl.descriptors.data.StackFrameData;
import com.intellij.debugger.impl.descriptors.data.StaticData;
import com.intellij.debugger.impl.descriptors.data.StaticFieldData;
import com.intellij.debugger.impl.descriptors.data.ThisData;
import com.intellij.debugger.impl.descriptors.data.ThreadData;
import com.intellij.debugger.impl.descriptors.data.ThreadGroupData;
import com.intellij.debugger.impl.descriptors.data.ThrownExceptionValueData;
import com.intellij.debugger.impl.descriptors.data.WatchItemData;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DescriptorTree;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MarkedDescriptorTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDescriptorFactoryImpl
implements NodeDescriptorFactory {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorFactoryImpl");
    private DescriptorTree a = new DescriptorTree(true);
    private DescriptorTreeSearcher b;
    private DescriptorTreeSearcher d;
    protected final Project myProject;

    public NodeDescriptorFactoryImpl(Project project2) {
        this.myProject = project2;
        this.b = new DescriptorTreeSearcher(new MarkedDescriptorTree());
        this.d = new DisplayDescriptorTreeSearcher(new MarkedDescriptorTree());
    }

    public void dispose() {
        this.a.clear();
        this.b.clear();
        this.d.clear();
    }

    @NotNull
    public <T extends NodeDescriptor> T getDescriptor(NodeDescriptor nodeDescriptor, DescriptorData<T> descriptorData) {
        T t2 = descriptorData.createDescriptor(this.myProject);
        T t3 = this.findDescriptor(nodeDescriptor, t2, descriptorData);
        if (t3 != null && t3.getClass() == t2.getClass()) {
            t2.setAncestor(t3);
        } else {
            T t4 = this.findDisplayDescriptor(nodeDescriptor, t2, descriptorData.getDisplayKey());
            if (t4 != null) {
                t2.displayAs(t4);
            }
        }
        this.a.addChild(nodeDescriptor, (NodeDescriptor)t2);
        T t5 = t2;
        if (t5 == null) {
            NodeDescriptorFactoryImpl.a(0);
        }
        return t5;
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDisplayDescriptor(NodeDescriptor nodeDescriptor, T t2, DisplayKey<T> displayKey) {
        return this.d.search(nodeDescriptor, t2, displayKey);
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDescriptor(NodeDescriptor nodeDescriptor, T t2, DescriptorData<T> descriptorData) {
        return this.b.search(nodeDescriptor, t2, descriptorData);
    }

    public DescriptorTree getCurrentHistoryTree() {
        return this.a;
    }

    public void deriveHistoryTree(DescriptorTree descriptorTree, StackFrameContext stackFrameContext) {
        this.deriveHistoryTree(descriptorTree, stackFrameContext.getFrameProxy());
    }

    public void deriveHistoryTree(DescriptorTree descriptorTree, StackFrameProxy stackFrameProxy) {
        final MarkedDescriptorTree markedDescriptorTree = new MarkedDescriptorTree();
        final MarkedDescriptorTree markedDescriptorTree2 = new MarkedDescriptorTree();
        descriptorTree.dfst(new DescriptorTree.DFSTWalker(){

            @Override
            public void visit(NodeDescriptor nodeDescriptor, NodeDescriptor nodeDescriptor2) {
                DescriptorData<NodeDescriptor> descriptorData = DescriptorData.getDescriptorData(nodeDescriptor2);
                markedDescriptorTree.addChild(nodeDescriptor, nodeDescriptor2, descriptorData);
                markedDescriptorTree2.addChild(nodeDescriptor, nodeDescriptor2, descriptorData.getDisplayKey());
            }
        });
        this.b = new DescriptorTreeSearcher(markedDescriptorTree);
        this.d = new DisplayDescriptorTreeSearcher(markedDescriptorTree2);
        this.a = NodeDescriptorFactoryImpl.a(stackFrameProxy, descriptorTree);
    }

    private static DescriptorTree a(StackFrameProxy stackFrameProxy, DescriptorTree descriptorTree) {
        int n2 = -1;
        int n3 = -1;
        if (stackFrameProxy != null) {
            try {
                ThreadReferenceProxy threadReferenceProxy = stackFrameProxy.threadProxy();
                n2 = threadReferenceProxy.frameCount();
                n3 = stackFrameProxy.getFrameIndex();
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        boolean bl2 = !descriptorTree.frameIdEquals(n2, n3);
        DescriptorTree descriptorTree2 = new DescriptorTree(bl2);
        descriptorTree2.setFrameId(n2, n3);
        return descriptorTree2;
    }

    @Override
    public ArrayElementDescriptorImpl getArrayItemDescriptor(NodeDescriptor nodeDescriptor, ArrayReference arrayReference, int n2) {
        return this.getDescriptor(nodeDescriptor, new ArrayItemData(arrayReference, n2));
    }

    @Override
    @NotNull
    public FieldDescriptorImpl getFieldDescriptor(NodeDescriptor nodeDescriptor, ObjectReference objectReference, Field field) {
        DescriptorData descriptorData;
        if (objectReference == null) {
            if (!field.isStatic()) {
                c.error("Object reference is null for non-static field: " + field);
            }
            descriptorData = new StaticFieldData(field);
        } else {
            descriptorData = new FieldData(objectReference, field);
        }
        FieldDescriptorImpl fieldDescriptorImpl = this.getDescriptor(nodeDescriptor, descriptorData);
        if (fieldDescriptorImpl == null) {
            NodeDescriptorFactoryImpl.a(1);
        }
        return fieldDescriptorImpl;
    }

    @Override
    public LocalVariableDescriptorImpl getLocalVariableDescriptor(NodeDescriptor nodeDescriptor, LocalVariableProxy localVariableProxy) {
        return this.getDescriptor(nodeDescriptor, new LocalData((LocalVariableProxyImpl)localVariableProxy));
    }

    public ArgumentValueDescriptorImpl getArgumentValueDescriptor(NodeDescriptor nodeDescriptor, DecompiledLocalVariable decompiledLocalVariable, Value value) {
        return this.getDescriptor(nodeDescriptor, new ArgValueData(decompiledLocalVariable, value));
    }

    public StackFrameDescriptorImpl getStackFrameDescriptor(@Nullable NodeDescriptorImpl nodeDescriptorImpl, @NotNull StackFrameProxyImpl stackFrameProxyImpl) {
        if (stackFrameProxyImpl == null) {
            NodeDescriptorFactoryImpl.a(2);
        }
        return this.getDescriptor(nodeDescriptorImpl, new StackFrameData(stackFrameProxyImpl));
    }

    public StaticDescriptorImpl getStaticDescriptor(NodeDescriptorImpl nodeDescriptorImpl, ReferenceType referenceType) {
        return this.getDescriptor(nodeDescriptorImpl, new StaticData(referenceType));
    }

    public ValueDescriptorImpl getThisDescriptor(NodeDescriptorImpl nodeDescriptorImpl, Value value) {
        return this.getDescriptor(nodeDescriptorImpl, new ThisData());
    }

    public ValueDescriptorImpl getMethodReturnValueDescriptor(NodeDescriptorImpl nodeDescriptorImpl, Method method, Value value) {
        return this.getDescriptor(nodeDescriptorImpl, new MethodReturnValueData(method, value));
    }

    public ValueDescriptorImpl getThrownExceptionObjectDescriptor(NodeDescriptorImpl nodeDescriptorImpl, ObjectReference objectReference) {
        return this.getDescriptor(nodeDescriptorImpl, new ThrownExceptionValueData(objectReference));
    }

    public ThreadDescriptorImpl getThreadDescriptor(NodeDescriptorImpl nodeDescriptorImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return this.getDescriptor(nodeDescriptorImpl, new ThreadData(threadReferenceProxyImpl));
    }

    public ThreadGroupDescriptorImpl getThreadGroupDescriptor(NodeDescriptorImpl nodeDescriptorImpl, ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl) {
        return this.getDescriptor(nodeDescriptorImpl, new ThreadGroupData(threadGroupReferenceProxyImpl));
    }

    @Override
    public UserExpressionDescriptor getUserExpressionDescriptor(NodeDescriptor nodeDescriptor, DescriptorData<UserExpressionDescriptor> descriptorData) {
        return this.getDescriptor(nodeDescriptor, descriptorData);
    }

    public WatchItemDescriptor getWatchItemDescriptor(NodeDescriptor nodeDescriptor, TextWithImports textWithImports, @Nullable Value value) {
        return this.getDescriptor(nodeDescriptor, new WatchItemData(textWithImports, value));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProxy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStackFrameDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisplayDescriptorTreeSearcher
    extends DescriptorTreeSearcher {
        public DisplayDescriptorTreeSearcher(MarkedDescriptorTree markedDescriptorTree) {
            super(markedDescriptorTree);
        }

        @Override
        protected NodeDescriptor getSearched(NodeDescriptor nodeDescriptor) {
            NodeDescriptor nodeDescriptor2 = super.getSearched(nodeDescriptor);
            if (nodeDescriptor2 == null) {
                return NodeDescriptorFactoryImpl.this.b.getSearched(nodeDescriptor);
            }
            return nodeDescriptor2;
        }
    }

    private static class DescriptorTreeSearcher {
        private final MarkedDescriptorTree b;
        private final HashMap<NodeDescriptor, NodeDescriptor> a = new HashMap();

        public DescriptorTreeSearcher(MarkedDescriptorTree markedDescriptorTree) {
            this.b = markedDescriptorTree;
        }

        @Nullable
        public <T extends NodeDescriptor> T search(NodeDescriptor nodeDescriptor, T t2, DescriptorKey<T> descriptorKey) {
            T t3;
            if (nodeDescriptor == null) {
                t3 = this.b.getChild(null, descriptorKey);
            } else {
                NodeDescriptor nodeDescriptor2 = this.getSearched(nodeDescriptor);
                t3 = nodeDescriptor2 != null ? this.b.getChild(nodeDescriptor2, descriptorKey) : null;
                Object v0 = t3;
            }
            if (t3 != null) {
                this.a.put(t2, (NodeDescriptor)t3);
            }
            return t3;
        }

        protected NodeDescriptor getSearched(NodeDescriptor nodeDescriptor) {
            return this.a.get(nodeDescriptor);
        }

        public void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

