/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadTimings {
    public static final Key<OverheadTimings> KEY = Key.create((String)"OVERHEAD_TIMINGS");
    private final EventDispatcher<OverheadTimingsListener> c = EventDispatcher.create(OverheadTimingsListener.class);
    private final Map<OverheadProducer, Timings> b = new ConcurrentHashMap<OverheadProducer, Timings>();
    private final List<Pair<Long, Timings>> a = new LinkedList<Pair<Long, Timings>>(){

        @Override
        public boolean add(Pair<Long, Timings> pair2) {
            if (this.size() > 10) {
                this.removeFirst();
            }
            boolean bl2 = super.add(pair2);
            if (this.a()) {
                ((OverheadTimingsListener)OverheadTimings.this.c.getMulticaster()).excessiveOverheadDetected();
            }
            return bl2;
        }

        private boolean a() {
            if (this.size() < 5) {
                return false;
            }
            long l3 = StreamEx.of((Collection)this).map(pair2 -> ((Timings)pair2.getSecond()).myTime).nonNull().mapToLong(l2 -> l2).sum();
            return l3 > (Long)((Pair)this.getLast()).first - (Long)((Pair)this.getFirst()).first;
        }
    };

    public static Long getTime(DebugProcess debugProcess, OverheadProducer overheadProducer) {
        Timings timings = OverheadTimings.a((DebugProcess)debugProcess).b.get(overheadProducer);
        return timings != null ? timings.myTime : null;
    }

    public static long getHits(DebugProcess debugProcess, OverheadProducer overheadProducer) {
        Timings timings = OverheadTimings.a((DebugProcess)debugProcess).b.get(overheadProducer);
        return timings != null ? timings.myHits : 0L;
    }

    public static Set<OverheadProducer> getProducers(DebugProcess debugProcess) {
        return OverheadTimings.a((DebugProcess)debugProcess).b.keySet();
    }

    public static void add(DebugProcess debugProcess, OverheadProducer overheadProducer, long l2, @Nullable Long l3) {
        OverheadTimings overheadTimings = OverheadTimings.a(debugProcess);
        Timings timings3 = new Timings(l2, l3);
        overheadTimings.a.add((Pair<Long, Timings>)Pair.create((Object)System.currentTimeMillis(), (Object)timings3));
        overheadTimings.b.merge(overheadProducer, timings3, (timings, timings2) -> {
            Long l2 = timings.myTime;
            if (timings2.myTime != null) {
                l2 = l2 + timings2.myTime;
            }
            return new Timings(timings.myHits + timings2.myHits, l2);
        });
        ((OverheadTimingsListener)overheadTimings.c.getMulticaster()).timingAdded(overheadProducer);
    }

    @NotNull
    private static OverheadTimings a(DebugProcess debugProcess) {
        OverheadTimings overheadTimings = (OverheadTimings)debugProcess.getUserData(KEY);
        if (overheadTimings == null) {
            overheadTimings = new OverheadTimings();
            debugProcess.putUserData(KEY, (Object)overheadTimings);
        }
        OverheadTimings overheadTimings2 = overheadTimings;
        if (overheadTimings2 == null) {
            OverheadTimings.a(0);
        }
        return overheadTimings2;
    }

    static void addListener(OverheadTimingsListener overheadTimingsListener, DebugProcess debugProcess) {
        OverheadTimings.a((DebugProcess)debugProcess).c.addListener((EventListener)overheadTimingsListener);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/overhead/OverheadTimings", "getTimings"));
    }

    public static interface OverheadTimingsListener
    extends EventListener {
        public void timingAdded(OverheadProducer var1);

        public void excessiveOverheadDetected();
    }

    private static class Timings {
        final long myHits;
        final Long myTime;

        public Timings(long l2, Long l3) {
            this.myHits = l2;
            this.myTime = l3;
        }
    }
}

