/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LabelRenderer
extends TypeRenderer
implements ValueLabelRenderer,
OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "LabelRenderer";
    public boolean ON_DEMAND;
    private CachedEvaluator b = this.createCachedEvaluator();

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public LabelRenderer clone() {
        LabelRenderer labelRenderer = (LabelRenderer)super.clone();
        labelRenderer.b = this.createCachedEvaluator();
        labelRenderer.setLabelExpression(this.getLabelExpression());
        return labelRenderer;
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        return null;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        String string;
        if (!this.isShowValue(valueDescriptor, evaluationContext)) {
            return "";
        }
        Value value = valueDescriptor.getValue();
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        if (value != null) {
            try {
                ExpressionEvaluator expressionEvaluator = this.b.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
                Value value2 = expressionEvaluator.evaluate(evaluationContext2);
                string = DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext2, (Value)value2);
            }
            catch (EvaluateException evaluateException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage(), (Throwable)evaluateException);
            }
        } else {
            string = "null";
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = "\u2026 " + this.getLabelExpression().getText();
        if (string == null) {
            LabelRenderer.b(0);
        }
        return string;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports textWithImports = DebuggerUtils.getInstance().readTextWithImports(element, "LABEL_EXPRESSION");
        if (textWithImports != null) {
            this.setLabelExpression(textWithImports);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "LABEL_EXPRESSION", this.getLabelExpression());
    }

    public TextWithImports getLabelExpression() {
        return this.b.getReferenceExpression();
    }

    public void setLabelExpression(TextWithImports textWithImports) {
        this.b.setReferenceExpression(textWithImports);
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        return this.ON_DEMAND || OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    public boolean isOnDemand() {
        return this.ON_DEMAND;
    }

    public void setOnDemand(boolean bl2) {
        this.ON_DEMAND = bl2;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/LabelRenderer", "getLinkText"));
    }
}

