/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.model.IComponentCopyProvider;
import com.intellij.designer.model.IComponentDeletionParticipant;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.uiDesigner.SerializedComponentData;
import com.intellij.util.ThrowableRunnable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonEditActionsProvider
implements DeleteProvider,
CopyProvider,
PasteProvider,
CutProvider {
    private static final DataFlavor b = FileCopyPasteUtil.createJvmDataFlavor(SerializedComponentData.class);
    public static boolean isDeleting;
    private final DesignerEditorPanel a;

    public CommonEditActionsProvider(DesignerEditorPanel designerEditorPanel) {
        this.a = designerEditorPanel;
    }

    protected EditableArea getArea(DataContext dataContext) {
        EditableArea editableArea = (EditableArea)EditableArea.DATA_KEY.getData(dataContext);
        return editableArea == null ? this.a.getSurfaceArea() : editableArea;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(0);
        }
        if (this.a.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> list2 = this.getArea(dataContext).getSelection();
        if (list2.isEmpty()) {
            return false;
        }
        for (RadComponent radComponent : list2) {
            if (radComponent.canDelete()) continue;
            return false;
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(1);
        }
        this.a.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            EditableArea editableArea;
            List<RadComponent> list2;
            if (dataContext == null) {
                CommonEditActionsProvider.a(12);
            }
            if ((list2 = (editableArea = this.getArea(dataContext)).getSelection()).isEmpty()) {
                return;
            }
            this.a.getToolProvider().loadDefaultTool();
            List<RadComponent> list3 = RadComponent.getPureSelection(list2);
            CommonEditActionsProvider.updateSelectionBeforeDelete(editableArea, list3.get(0), list2);
            CommonEditActionsProvider.a(list3);
        }), DesignerBundle.message("command.delete.selection", new Object[0]), true);
    }

    private static void a(@NotNull List<RadComponent> list2) throws Exception {
        if (list2 == null) {
            CommonEditActionsProvider.a(2);
        }
        Map<RadComponent, List<RadComponent>> map = RadComponent.groupSiblings(list2);
        for (Map.Entry<RadComponent, List<RadComponent>> entry : map.entrySet()) {
            IComponentDeletionParticipant iComponentDeletionParticipant;
            RadComponent radComponent = entry.getKey();
            List<RadComponent> list3 = entry.getValue();
            boolean bl2 = false;
            if (radComponent instanceof IComponentDeletionParticipant) {
                iComponentDeletionParticipant = (IComponentDeletionParticipant)((Object)radComponent);
                bl2 = iComponentDeletionParticipant.deleteChildren(radComponent, list3);
            } else if (radComponent != null && radComponent.getLayout() instanceof IComponentDeletionParticipant) {
                iComponentDeletionParticipant = (IComponentDeletionParticipant)((Object)radComponent.getLayout());
                bl2 = iComponentDeletionParticipant.deleteChildren(radComponent, list3);
            }
            if (bl2) continue;
            CommonEditActionsProvider.b(list3);
        }
    }

    private static void b(List<RadComponent> list2) throws Exception {
        if (list2.get(0) instanceof IGroupDeleteComponent) {
            ((IGroupDeleteComponent)((Object)list2.get(0))).delete(list2);
        } else {
            for (RadComponent radComponent : list2) {
                radComponent.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSelectionBeforeDelete(EditableArea editableArea, RadComponent radComponent, List<RadComponent> list2) {
        try {
            isDeleting = true;
            RadComponent radComponent2 = CommonEditActionsProvider.a(radComponent, list2);
            if (radComponent2 == null) {
                editableArea.deselectAll();
            } else {
                editableArea.select(radComponent2);
            }
        }
        finally {
            isDeleting = false;
        }
    }

    @Nullable
    private static RadComponent a(RadComponent radComponent, List<RadComponent> list2) {
        RadComponent radComponent2 = radComponent.getParent();
        if (radComponent2 == null) {
            return null;
        }
        List<RadComponent> list3 = radComponent2.getChildren();
        int n2 = list3.size();
        for (int i2 = list3.indexOf((Object)radComponent) + 1; i2 < n2; ++i2) {
            RadComponent radComponent3 = list3.get(i2);
            if (list2.contains((Object)radComponent3)) continue;
            return radComponent3;
        }
        return radComponent2;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(3);
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(4);
        }
        if (this.a.getInplaceEditingLayer().isEditing()) {
            return false;
        }
        List<RadComponent> list2 = this.getArea(dataContext).getSelection();
        if (list2.isEmpty()) {
            return false;
        }
        RadComponent radComponent = this.a.getRootComponent();
        if (radComponent instanceof IComponentCopyProvider) {
            IComponentCopyProvider iComponentCopyProvider = (IComponentCopyProvider)((Object)radComponent);
            return iComponentCopyProvider.isCopyEnabled(list2);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(5);
        }
        this.a(dataContext);
    }

    private boolean a(DataContext dataContext) {
        try {
            Object object;
            Element element = new Element("designer");
            element.setAttribute("target", this.a.getPlatformTarget());
            List<RadComponent> list2 = RadComponent.getPureSelection(this.getArea(dataContext).getSelection());
            RadComponent radComponent = this.a.getRootComponent();
            if (radComponent instanceof IComponentCopyProvider) {
                object = (IComponentCopyProvider)((Object)radComponent);
                object.copyTo(element, list2);
            } else {
                for (RadComponent radComponent2 : list2) {
                    radComponent2.copyTo(element);
                }
            }
            object = new SerializedComponentData(new XMLOutputter().outputString(element));
            CopyPasteManager.getInstance().setContents((Transferable)new SimpleTransferable(object, b));
            return true;
        }
        catch (Throwable throwable) {
            this.a.showError("Copy error", throwable);
            return false;
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(6);
        }
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(7);
        }
        return !this.a.getInplaceEditingLayer().isEditing() && this.a() != null;
    }

    @Nullable
    private String a() {
        try {
            SerializedComponentData serializedComponentData;
            String string;
            Object object = CopyPasteManager.getInstance().getContents(b);
            if (object instanceof SerializedComponentData && (string = (serializedComponentData = (SerializedComponentData)object).getSerializedComponents()).startsWith("<designer target=\"" + this.a.getPlatformTarget() + "\">")) {
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        ComponentPasteFactory componentPasteFactory;
        if (dataContext == null) {
            CommonEditActionsProvider.a(8);
        }
        if ((componentPasteFactory = this.a.createPasteFactory(this.a())) != null) {
            this.a.getToolProvider().setActiveTool(new PasteTool(true, componentPasteFactory));
        }
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(9);
        }
        return true;
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(10);
        }
        return this.isCopyEnabled(dataContext) && this.canDeleteElement(dataContext);
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CommonEditActionsProvider.a(11);
        }
        if (this.a(dataContext)) {
            this.deleteElement(dataContext);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        objectArray2[1] = "com/intellij/designer/actions/CommonEditActionsProvider";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDeletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutVisible";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "performCut";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$deleteElement$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

