/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea g;
    private final ToolProvider c;
    private final Class[] f;
    private final OperationContext b = new OperationContext();
    private DropTargetDragEvent a;
    private EditOperation j;
    private RadComponent h;
    private boolean e;
    private boolean i;
    private static final Cursor d = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.g = editableArea;
        this.b.setArea(editableArea);
        this.c = toolProvider;
        this.f = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.c();
        this.a(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.a = dropTargetDragEvent;
        this.g();
        this.d();
        this.b();
        this.e();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.c();
        this.f();
        this.a(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void e() {
        if (this.j != null) {
            this.j.showFeedback();
        }
        this.i = true;
    }

    private void c() {
        if (this.i) {
            this.i = false;
            if (this.j != null) {
                this.j.eraseFeedback();
            }
        }
    }

    private void g() {
        this.b.setLocation(this.a());
        if (this.b.getComponents() == null) {
            if (!ArrayUtil.contains((Object)SimpleTransferable.getData(this.a.getTransferable(), Class.class), (Object[])this.f)) {
                this.b.setComponents(Collections.emptyList());
                return;
            }
            if (this.c.getActiveTool() instanceof CreationTool) {
                this.b.setType("create_children");
                CreationTool creationTool = (CreationTool)this.c.getActiveTool();
                try {
                    this.b.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.b.setComponents(Collections.emptyList());
                    this.c.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list2 = RadComponent.getPureSelection(this.g.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list2) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list2 = Collections.emptyList();
                break;
            }
            this.b.setComponents(list2);
            this.b.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list2) {
                radComponent2.processDropOperation(this.b);
            }
        }
    }

    private void d() {
        if (this.b.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.b.getComponents());
        if (!this.b.isCreate()) {
            for (RadComponent object2 : this.b.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.b.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.b.isCreate()) {
                    if (TreeDropListener.this.b.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.b.setType("move_children");
                    } else {
                        TreeDropListener.this.b.setType("add_children");
                    }
                }
                if (TreeDropListener.this.h == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.b);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.a();
        RadComponent radComponent = this.g.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.h) {
            if (this.j != null) {
                this.c();
            }
            this.h = radComponent;
            this.j = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.b.isCreate()) {
                this.b.setType(null);
            }
        } else {
            this.j.setComponents(this.b.getComponents());
        }
    }

    private Point a() {
        return this.a.getLocation();
    }

    private void b() {
        if (this.j != null) {
            if (this.b.isMove()) {
                this.b(this.b.isMoveEnabled() && this.j.canExecute());
            } else if (this.b.isAdd()) {
                this.b(this.b.isAddEnabled() && this.j.canExecute());
            } else if (this.b.isCreate()) {
                this.b(this.j.canExecute());
            } else {
                this.b(false);
            }
        } else {
            this.b(false);
        }
    }

    private void b(boolean bl2) {
        this.e = bl2;
        if (bl2) {
            this.a.acceptDrag(this.a.getDropAction());
            this.g.setCursor(this.b.isCreate() ? Cursors.getCopyCursor() : d);
        } else {
            this.a.rejectDrag();
            this.g.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void f() {
        if (this.e) {
            this.c.execute(Collections.singletonList(this.j), this.b.getMessage());
            if (this.b.isCreate()) {
                this.g.setSelection(this.b.getComponents());
            }
        }
    }

    private void a(boolean bl2) {
        this.b.setComponents(null);
        this.a = null;
        this.j = null;
        this.h = null;
        this.e = false;
        if (bl2 || !this.b.isCreate()) {
            this.b.setType(null);
            this.c.loadDefaultTool();
        }
        this.g.setCursor(null);
    }
}

