/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InplaceEditingLayer
extends JComponent {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.designer.designSurface.InplaceEditingLayer");
    private final FocusWatcher j = new FocusWatcher(){

        protected void focusLostImpl(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (focusEvent.isTemporary() || component != null && SwingUtilities.isDescendingFrom(component, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.a(true), ModalityState.NON_MODAL);
        }
    };
    private final ComponentSelectionListener e = new ComponentSelectionListener(){

        @Override
        public void selectionChanged(EditableArea editableArea) {
            InplaceEditingLayer.this.a(true);
        }
    };
    private PropertyEditorListener i = new PropertyEditorListener(){

        public void valueCommitted(PropertyEditor propertyEditor, boolean bl2, boolean bl3) {
            InplaceEditingLayer.this.a(true);
        }

        public void editingCanceled(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a(false);
        }

        public void preferredSizeChanged(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.b();
        }
    };
    private RadComponent d;
    private List<Property> b;
    private List<PropertyEditor> a;
    private final DesignerEditorPanel c;
    private JComponent g;
    private int h;

    public InplaceEditingLayer(DesignerEditorPanel designerEditorPanel) {
        this.c = designerEditorPanel;
    }

    public void startEditing(@Nullable InplaceContext inplaceContext) {
        try {
            JComponent jComponent;
            List<RadComponent> list2 = this.c.getSurfaceArea().getSelection();
            if (list2.size() != 1) {
                return;
            }
            this.d = list2.get(0);
            this.b = this.d.getInplaceProperties();
            if (this.b.isEmpty()) {
                this.d = null;
                this.b = null;
                return;
            }
            this.g = new JPanel((LayoutManager)new GridLayoutManager(this.b.size(), 2));
            this.g.setBorder(new LineMarginBorder(5, 5, 5, 5));
            new AnAction(){

                public void actionPerformed(AnActionEvent anActionEvent) {
                    InplaceEditingLayer.this.a(false);
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.g);
            this.a = new ArrayList<PropertyEditor>();
            JComponent jComponent2 = null;
            Font font = null;
            if (inplaceContext == null) {
                inplaceContext = new InplaceContext();
            }
            int n2 = 0;
            for (Property object2 : this.b) {
                jComponent = new JLabel(object2.getName() + ":");
                if (font == null) {
                    font = jComponent.getFont().deriveFont(1);
                }
                jComponent.setFont(font);
                this.g.add((Component)jComponent, new GridConstraints(n2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                PropertyEditor propertyEditor = object2.getEditor();
                this.a.add(propertyEditor);
                JComponent jComponent3 = propertyEditor.getComponent((PropertiesContainer)this.d, (PropertyContext)this.c, object2.getValue((PropertiesContainer)this.d), inplaceContext);
                this.g.add((Component)jComponent3, new GridConstraints(n2++, 1, 1, 1, 0, 1, 2, 0, null, null, null));
                if (jComponent2 != null) continue;
                jComponent2 = propertyEditor.getPreferredFocusedComponent();
            }
            for (PropertyEditor propertyEditor : this.a) {
                propertyEditor.addPropertyEditorListener(this.i);
            }
            Rectangle rectangle = this.d.getBounds(this);
            Dimension dimension = this.g.getPreferredSize();
            this.h = Math.max(dimension.width, rectangle.width);
            this.g.setBounds(rectangle.x, rectangle.y, this.h, dimension.height);
            this.add(this.g);
            this.c.getSurfaceArea().addSelectionListener(this.e);
            if (jComponent2 == null) {
                jComponent2 = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.g);
            }
            if (jComponent2 == null) {
                jComponent2 = this.g;
            }
            if (jComponent2.requestFocusInWindow()) {
                this.j.install((Component)this.g);
            } else {
                this.grabFocus();
                jComponent = jComponent2;
                ApplicationManager.getApplication().invokeLater(() -> {
                    jComponent.requestFocusInWindow();
                    this.j.install((Component)this.g);
                });
            }
            this.enableEvents(16L);
            this.repaint();
        }
        catch (Throwable throwable) {
            f.error(throwable);
        }
    }

    private void a(boolean bl2) {
        this.c.getSurfaceArea().removeSelectionListener(this.e);
        if (this.g != null) {
            if (bl2) {
                this.c.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                    int n2 = this.b.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object object;
                        Property property = this.b.get(i2);
                        Object object2 = property.getValue((PropertiesContainer)this.d);
                        if (Comparing.equal((Object)object2, (Object)(object = this.a.get(i2).getValue()))) continue;
                        property.setValue((PropertiesContainer)this.d, object);
                    }
                }), DesignerBundle.message("command.set.property.value", new Object[0]), true);
            }
            for (PropertyEditor propertyEditor : this.a) {
                propertyEditor.removePropertyEditorListener(this.i);
            }
            this.a();
            this.j.deinstall((Component)this.g);
            this.g = null;
        }
        this.d = null;
        this.b = null;
        this.a = null;
        this.c.getPreferredFocusedComponent().requestFocusInWindow();
        this.disableEvents(16L);
        this.repaint();
    }

    private void b() {
        this.g.revalidate();
        Dimension dimension = this.g.getPreferredSize();
        this.g.setSize(Math.max(dimension.width, this.h), this.g.getHeight());
        this.g.revalidate();
        this.repaint();
    }

    private void a() {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent((JComponent)this.c.getPreferredFocusedComponent());
        try {
            this.remove(this.g);
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.g != null && (501 == mouseEvent.getID() || 502 == mouseEvent.getID())) {
            this.a(true);
        }
        super.processMouseEvent(mouseEvent);
    }

    public boolean isEditing() {
        return this.g != null;
    }
}

