/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int j;
    private final String h;
    private OperationContext f;
    private List<EditOperation> i;
    private boolean g;

    public ResizeTracker(int n2, Object object, @Nullable String string) {
        this.j = n2;
        this.h = string;
        this.f = new OperationContext(object);
        this.f.setResizeDirection(n2);
        this.setDefaultCursor(Cursors.getResizeCursor(n2));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.h;
    }

    @Override
    public void deactivate() {
        this.f();
        this.f = null;
        this.i = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.f();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.myState = 0;
            this.f();
            this.c();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.d();
            this.b();
            this.e();
        }
    }

    private void b() {
        for (EditOperation editOperation : this.g()) {
            editOperation.showFeedback();
        }
        this.g = true;
    }

    private void f() {
        if (this.g) {
            this.g = false;
            for (EditOperation editOperation : this.g()) {
                editOperation.eraseFeedback();
            }
        }
    }

    private void c() {
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> arrayList = new ArrayList<EditOperation>();
            for (EditOperation editOperation : this.g()) {
                if (!editOperation.canExecute()) continue;
                arrayList.add(editOperation);
            }
            this.myToolProvider.execute(arrayList, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void e() {
        for (EditOperation editOperation : this.g()) {
            if (!editOperation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void d() {
        this.f.setArea(this.myArea);
        this.f.setInputEvent(this.myInputEvent);
        this.f.setModifiers(this.myModifiers);
        Point point = new Point();
        Dimension dimension = new Dimension();
        int n2 = this.moveDeltaWidth();
        if ((this.j & 4) != 0) {
            point.x += n2;
            dimension.width -= n2;
        } else if ((this.j & 8) != 0) {
            dimension.width += n2;
        }
        int n3 = this.moveDeltaHeight();
        if ((this.j & 1) != 0) {
            point.y += n3;
            dimension.height -= n3;
        } else if ((this.j & 2) != 0) {
            dimension.height += n3;
        }
        this.f.setMoveDelta(point);
        this.f.setSizeDelta(dimension);
        this.f.setLocation(this.getLocation());
    }

    private List<EditOperation> g() {
        if (this.i == null) {
            this.f.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.i = new ArrayList<EditOperation>();
            for (RadComponent radComponent : this.f.getComponents()) {
                RadComponent radComponent2 = radComponent.getParent();
                EditOperation editOperation = radComponent2 == null ? this.myArea.processRootOperation(this.f) : radComponent2.getLayout().processChildOperation(this.f);
                if (editOperation == null) continue;
                this.i.add(editOperation);
                editOperation.setComponent(radComponent);
            }
        }
        return this.i;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyPressed(keyEvent, editableArea);
        if (keyEvent.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        } else if (bl2) {
            this.a();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyReleased(keyEvent, editableArea);
        if (bl2) {
            this.a();
        }
    }

    private void a() {
        if (this.f != null) {
            this.d();
            this.b();
            this.e();
        }
    }
}

