/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Cursor;
import java.awt.event.KeyEvent;

public class SelectionTracker
extends TargetingTool {
    protected final RadComponent myComponent;
    private boolean g;

    public SelectionTracker(RadComponent radComponent) {
        this.myComponent = radComponent;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.g = false;
    }

    @Override
    protected Cursor calculateCursor() {
        return this.myState == 1 || this.myState == 2 ? this.getDefaultCursor() : super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (!(this.myState != 1 || n2 != 1 && n2 != 3 || this.myArea.isSelected(this.myComponent))) {
            this.a();
        }
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = n2 == 3 ? 0 : 4;
            this.handleInvalidInput();
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 2) {
            if (SystemInfo.isMac && this.myInputEvent != null && this.myInputEvent.isControlDown()) {
                return;
            }
            this.a();
            this.myState = 0;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        super.keyPressed(keyEvent, editableArea);
        if (keyEvent.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    private void a() {
        if (this.g || this.myArea.isTree()) {
            return;
        }
        this.g = true;
        SelectionTracker.performSelection(this, this.myComponent);
    }

    public static void performSelection(InputTool inputTool, RadComponent radComponent) {
        if (SystemInfo.isMac ? inputTool.myInputEvent.isMetaDown() : inputTool.myInputEvent.isControlDown()) {
            if (inputTool.myArea.isSelected(radComponent)) {
                inputTool.myArea.deselect(radComponent);
            } else {
                inputTool.myArea.appendSelection(radComponent);
            }
        } else if (inputTool.myInputEvent.isShiftDown()) {
            inputTool.myArea.appendSelection(radComponent);
        } else {
            inputTool.myArea.select(radComponent);
        }
    }
}

