/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomProvider;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.util.ThrowableRunnable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ToolProvider
implements ZoomProvider {
    private InputTool c;
    private EditableArea b;
    private MouseEvent a;

    public void processKeyEvent(KeyEvent keyEvent, EditableArea editableArea) {
        if (this.c != null) {
            try {
                switch (keyEvent.getID()) {
                    case 401: {
                        this.c.keyPressed(keyEvent, editableArea);
                        break;
                    }
                    case 400: {
                        this.c.keyTyped(keyEvent, editableArea);
                        break;
                    }
                    case 402: {
                        this.c.keyReleased(keyEvent, editableArea);
                    }
                }
            }
            catch (Throwable throwable) {
                this.showError("Edit operation", throwable);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, EditableArea editableArea) {
        if (this.c != null) {
            try {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.c.mouseDown(mouseEvent, editableArea);
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.c.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 502: {
                        this.c.mouseUp(mouseEvent, editableArea);
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.c.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 504: {
                        this.c.mouseEntered(mouseEvent, editableArea);
                        break;
                    }
                    case 505: {
                        this.c.mouseExited(mouseEvent, editableArea);
                        break;
                    }
                    case 500: {
                        if (mouseEvent.getClickCount() == 2) {
                            this.c.mouseDoubleClick(mouseEvent, editableArea);
                        }
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.c.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 503: {
                        this.c.mouseMove(mouseEvent, editableArea);
                        break;
                    }
                    case 506: {
                        this.c.mouseDrag(mouseEvent, editableArea);
                    }
                }
            }
            catch (Throwable throwable) {
                this.showError("Edit operation", throwable);
            }
        }
    }

    public void setEvent(MouseEvent mouseEvent) {
        this.a = mouseEvent;
    }

    public void setArea(@Nullable EditableArea editableArea) {
        this.b = editableArea;
    }

    public abstract void showError(@NonNls String var1, Throwable var2);

    public InputTool getActiveTool() {
        return this.c;
    }

    public void setActiveTool(InputTool inputTool) {
        if (this.c != null) {
            this.c.deactivate();
        }
        this.c = inputTool;
        if (this.c != null) {
            this.c.setToolProvider(this);
            this.c.activate();
            if (this.b != null) {
                this.c.setArea(this.b);
                this.c.refreshCursor();
                try {
                    this.c.mouseMove(this.a, this.b);
                }
                catch (Exception exception) {
                    this.showError("Edit operation", exception);
                }
            }
        }
    }

    public abstract void loadDefaultTool();

    public abstract boolean execute(ThrowableRunnable<Exception> var1, String var2, boolean var3);

    public abstract void executeWithReparse(ThrowableRunnable<Exception> var1, String var2);

    public abstract void execute(List<EditOperation> var1, String var2);

    public abstract void startInplaceEditing(@Nullable InplaceContext var1);

    public abstract void hideInspections();
}

