/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspector.impl;

import com.intellij.designer.inspector.Property;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class InspectorTreeUtil {
    public static int getNodeDepth(JTree jTree, TreeNode treeNode) {
        TreePath treePath = TreeUtil.getPathFromRoot((TreeNode)treeNode);
        return treePath.getPathCount() - (jTree.isRootVisible() ? 1 : 2);
    }

    public static int getAvailableWidth(JTree jTree, Property property) {
        return InspectorTreeUtil.getAvailableWidth(jTree, InspectorTreeUtil.getNodeDepth(jTree, property));
    }

    public static int getAvailableWidth(JTree jTree, int n2) {
        return jTree.getSize().width - (jTree.getInsets().right + jTree.getInsets().left + InspectorTreeUtil.getRowX(jTree, n2));
    }

    public static void invalidateTreeHeightCache(JTree jTree) {
        jTree.setRowHeight(1);
        jTree.setRowHeight(-1);
    }

    @Nullable
    public static <T extends Component> T getParentOfType(Component component, Class<T> clazz) {
        Container container = component.getParent();
        while (container != null) {
            if (!clazz.isInstance(container)) continue;
            return (T)container;
        }
        return null;
    }

    public static int getRowX(JTree jTree, int n2) {
        TreeUI treeUI = jTree.getUI();
        if (treeUI instanceof BasicTreeUI) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
            return (basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent()) * n2;
        }
        int n3 = UIUtil.getTreeLeftChildIndent();
        int n4 = UIUtil.getTreeRightChildIndent();
        return (n3 + n4) * n2;
    }
}

