/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteContainer;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PalettePanel
extends JPanel
implements DataProvider,
PaletteToolWindowContent {
    private final JPanel e = new PaletteContainer();
    private List<PaletteGroupComponent> g = Collections.emptyList();
    private List<PaletteItemsComponent> a = Collections.emptyList();
    private List<PaletteGroup> c = Collections.emptyList();
    private DesignerEditorPanel b;
    private final FocusListener d = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            for (PaletteItemsComponent paletteItemsComponent : PalettePanel.this.a) {
                paletteItemsComponent.clearSelection();
            }
        }
    };
    private final ListSelectionListener h = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PalettePanel.this.a(listSelectionEvent);
        }
    };
    private final DragSourceListener f = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            Component component = dragSourceDropEvent.getDragSourceContext().getComponent();
            if (!dragSourceDropEvent.getDropSuccess() && component instanceof PaletteItemsComponent && PalettePanel.this.b != null && PalettePanel.this.b.getRootPane() == ((JComponent)component).getRootPane()) {
                PalettePanel.this.b.getToolProvider().loadDefaultTool();
            }
        }
    };

    public PalettePanel() {
        super(new GridLayout(1, 1));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.e);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                PalettePanel.this.clearActiveItem();
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)jScrollPane);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.f);
        }
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.f);
        }
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupComponent paletteGroupComponent : this.g) {
            PaletteItem paletteItem;
            if (!paletteGroupComponent.isSelected() || (paletteItem = (PaletteItem)paletteGroupComponent.getItemsComponent().getSelectedValue()) == null) continue;
            return paletteItem;
        }
        return null;
    }

    @Override
    public void clearActiveItem() {
        if (this.getActiveItem() != null) {
            for (PaletteItemsComponent paletteItemsComponent : this.a) {
                paletteItemsComponent.clearSelection();
            }
            this.a(null);
        }
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public void loadPalette(@Nullable DesignerEditorPanel designerEditorPanel) {
        if (this.b == null && designerEditorPanel == null) {
            return;
        }
        if (this.b != null && designerEditorPanel != null && this.c.equals(designerEditorPanel.getPaletteGroups())) {
            this.b = designerEditorPanel;
            this.a();
            return;
        }
        for (PaletteItemsComponent object : this.a) {
            object.removeListSelectionListener(this.h);
        }
        this.b = designerEditorPanel;
        this.e.removeAll();
        if (designerEditorPanel == null) {
            this.c = Collections.emptyList();
            this.g = Collections.emptyList();
            this.a = Collections.emptyList();
        } else {
            this.c = designerEditorPanel.getPaletteGroups();
            this.g = new ArrayList<PaletteGroupComponent>();
            this.a = new ArrayList<PaletteItemsComponent>();
        }
        for (PaletteGroup paletteGroup : this.c) {
            PaletteGroupComponent paletteGroupComponent = new PaletteGroupComponent(paletteGroup);
            PaletteItemsComponent paletteItemsComponent = new PaletteItemsComponent(paletteGroup, designerEditorPanel);
            paletteGroupComponent.setItemsComponent(paletteItemsComponent);
            paletteGroupComponent.addFocusListener(this.d);
            this.g.add(paletteGroupComponent);
            paletteItemsComponent.addListSelectionListener(this.h);
            this.a.add(paletteItemsComponent);
            this.e.add(paletteGroupComponent);
            this.e.add((Component)((Object)paletteItemsComponent));
        }
        this.e.revalidate();
        if (this.b != null) {
            this.a();
        }
    }

    private void a() {
        PaletteItem paletteItem = this.b.getActivePaletteItem();
        for (PaletteItemsComponent paletteItemsComponent : this.a) {
            paletteItemsComponent.restoreSelection(paletteItem);
        }
    }

    private void a(@Nullable ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            PaletteItemsComponent paletteItemsComponent = (PaletteItemsComponent)((Object)listSelectionEvent.getSource());
            for (int i2 = listSelectionEvent.getFirstIndex(); i2 <= listSelectionEvent.getLastIndex(); ++i2) {
                if (!paletteItemsComponent.isSelectedIndex(i2)) continue;
                for (PaletteItemsComponent paletteItemsComponent2 : this.a) {
                    if (paletteItemsComponent2 == paletteItemsComponent) continue;
                    paletteItemsComponent2.clearSelection();
                }
                PaletteItem paletteItem = (PaletteItem)paletteItemsComponent.getSelectedValue();
                if (paletteItem == null || paletteItem.isEnabled()) break;
                paletteItemsComponent.clearSelection();
                break;
            }
        }
        if (this.b != null) {
            this.b.activatePaletteItem(this.getActiveItem());
        }
    }

    public Object getData(@NonNls String string) {
        if (PlatformDataKeys.FILE_EDITOR.is(string) && this.b != null) {
            return this.b.getEditor();
        }
        return null;
    }
}

