/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.utils;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import org.jetbrains.annotations.Nullable;

public final class Cursors {
    public static final Cursor RESIZE_ALL = Cursor.getPredefinedCursor(13);
    public static final Cursor CROSS = Cursor.getPredefinedCursor(1);
    public static Cursor NO_CURSOR;

    public static Cursor getSystemNoCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveNoDrop.32x32");
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getNoCursor() {
        if (NO_CURSOR == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(Cursors.class.getResource("no-cursor.gif"));
            NO_CURSOR = toolkit.createCustomCursor(image, new Point(), "No_Cursor");
        }
        return NO_CURSOR;
    }

    public static Cursor getMoveCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveDrop.32x32");
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getCopyCursor() {
        try {
            return Cursor.getSystemCustomCursor("CopyDrop.32x32");
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    @Nullable
    public static Cursor getResizeCursor(int n2) {
        int n3;
        if (n2 == 5) {
            n3 = 6;
        } else if (n2 == 1) {
            n3 = 8;
        } else if (n2 == 9) {
            n3 = 7;
        } else if (n2 == 4) {
            n3 = 10;
        } else if (n2 == 8) {
            n3 = 11;
        } else if (n2 == 6) {
            n3 = 4;
        } else if (n2 == 2) {
            n3 = 9;
        } else if (n2 == 10) {
            n3 = 5;
        } else {
            return null;
        }
        return Cursor.getPredefinedCursor(n3);
    }
}

