/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestFrameworkDebuggerRunner
extends GenericDebuggerRunner {
    @Override
    @NotNull
    public abstract String getRunnerId();

    protected abstract boolean validForProfile(@NotNull RunProfile var1);

    @NotNull
    protected abstract String getThreadName();

    @Override
    public boolean canRun(@NotNull String string, @NotNull RunProfile runProfile) {
        if (string == null) {
            JavaTestFrameworkDebuggerRunner.b(0);
        }
        if (runProfile == null) {
            JavaTestFrameworkDebuggerRunner.b(1);
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(string) && this.validForProfile(runProfile);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(final @NotNull RunProfileState runProfileState, final @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (runProfileState == null) {
            JavaTestFrameworkDebuggerRunner.b(2);
        }
        if (executionEnvironment == null) {
            JavaTestFrameworkDebuggerRunner.b(3);
        }
        final RunContentDescriptor runContentDescriptor = super.createContentDescriptor(runProfileState, executionEnvironment);
        final ServerSocket serverSocket = ((JavaTestFrameworkRunnableState)runProfileState).getForkSocket();
        if (serverSocket != null) {
            Thread thread = new Thread(this.getThreadName() + " debugger runner"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (Socket socket = serverSocket.accept();
                         DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());){
                        int n2 = dataInputStream.readInt();
                        while (n2 != -1) {
                            DebugProcess debugProcess = DebuggerManager.getInstance((Project)executionEnvironment.getProject()).getDebugProcess(runContentDescriptor.getProcessHandler());
                            if (debugProcess == null) {
                                break;
                            }
                            RemoteConnection remoteConnection = new RemoteConnection(true, "127.0.0.1", String.valueOf(n2), true);
                            DefaultDebugEnvironment defaultDebugEnvironment = new DefaultDebugEnvironment(executionEnvironment, runProfileState, remoteConnection, true);
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    ((DebugProcessImpl)debugProcess).reattach(defaultDebugEnvironment);
                                    socket.getOutputStream().write(0);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            });
                            n2 = dataInputStream.readInt();
                        }
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        return runContentDescriptor;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaTestFrameworkDebuggerRunner";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createContentDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

