/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.structureView.impl.StructureNodeRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodListDlg
extends DialogWrapper {
    private final PsiClass e;
    private static final Comparator<PsiMethod> a = (psiMethod, psiMethod2) -> psiMethod.getName().compareToIgnoreCase(psiMethod2.getName());
    private final SortedListModel<PsiMethod> d = new SortedListModel(a);
    private final JList c = new JBList(this.d);
    private final JPanel b = new JPanel(new BorderLayout());

    public MethodListDlg(PsiClass psiClass, Condition<PsiMethod> condition, JComponent jComponent) {
        super((Component)jComponent, false);
        this.e = psiClass;
        this.a(psiClass.getAllMethods(), condition);
        this.b.add(ScrollPaneFactory.createScrollPane((Component)this.c));
        this.c.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                if (jList == null) {
                    1.a(0);
                }
                PsiMethod psiMethod = (PsiMethod)object;
                this.append(PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)0), StructureNodeRenderer.applyDeprecation((Object)psiMethod, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                PsiClass psiClass = psiMethod.getContainingClass();
                if (!MethodListDlg.this.e.equals(psiClass)) {
                    this.append(" (" + psiClass.getQualifiedName() + ")", StructureNodeRenderer.applyDeprecation((Object)psiClass, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/MethodListDlg$1", "customizeCellRenderer"));
            }
        });
        this.c.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent mouseEvent) {
                MethodListDlg.this.close(0);
                return true;
            }
        }.installOn((Component)this.c);
        ScrollingUtil.ensureSelectionExists((JList)this.c);
        TreeUIHelper.getInstance().installListSpeedSearch(this.c);
        this.setTitle(ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void a(PsiMethod[] psiMethodArray, Condition<PsiMethod> condition) {
        for (int i2 = 0; i2 < psiMethodArray.length; ++i2) {
            PsiMethod psiMethod = psiMethodArray[i2];
            if (!condition.value((Object)psiMethod)) continue;
            this.d.add((Object)psiMethod);
        }
    }

    protected JComponent createCenterPanel() {
        return this.b;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.c;
    }

    public PsiMethod getSelected() {
        return (PsiMethod)this.c.getSelectedValue();
    }
}

