/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TestClassCollector {
    private static final Logger a = Logger.getInstance(TestClassCollector.class);

    public static String[] collectClassFQNames(final String string, @Nullable Path path, JavaTestConfigurationBase javaTestConfigurationBase, Function<ClassLoader, Predicate<Class<?>>> function) {
        Module module2 = ((JavaRunConfigurationModule)javaTestConfigurationBase.getConfigurationModule()).getModule();
        final ClassLoader classLoader = TestClassCollector.createUsersClassLoader(javaTestConfigurationBase);
        final HashSet hashSet = new HashSet();
        try {
            String string2 = string.replace('.', '/');
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            final Predicate<Class<?>> predicate = function.apply(classLoader);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if ("jar".equals(uRL.getProtocol())) continue;
                final Path path2 = Paths.get(uRL.toURI());
                if (path != null && !path2.startsWith(path)) continue;
                final String string3 = path2.getFileSystem().getSeparator();
                Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        ProgressManager.checkCanceled();
                        FileVisitResult fileVisitResult = super.visitFile(path, basicFileAttributes);
                        File file = path.toFile();
                        String string4 = file.getName();
                        if (string4.endsWith(".class")) {
                            try {
                                Path path22 = path2.relativize(path.getParent());
                                String string2 = StringUtil.getQualifiedName((String)path22.toString().replace(string3, "."), (String)FileUtil.getNameWithoutExtension((String)string4));
                                String string32 = StringUtil.getQualifiedName((String)string, (String)string2);
                                Class<?> clazz = Class.forName(string32, false, classLoader);
                                int n2 = clazz.getModifiers();
                                if (Modifier.isAbstract(n2) || !Modifier.isPublic(n2) || clazz.isMemberClass() && !Modifier.isStatic(n2)) {
                                    return fileVisitResult;
                                }
                                if (predicate.test(clazz)) {
                                    hashSet.add(string32);
                                }
                            }
                            catch (Throwable throwable) {
                                a.info("error processing: " + string4 + " of " + path2.toString(), throwable);
                            }
                        }
                        return fileVisitResult;
                    }
                });
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Throwable throwable) {
            a.error(throwable);
        }
        return ArrayUtil.toStringArray(hashSet);
    }

    public static ClassLoader createUsersClassLoader(JavaTestConfigurationBase javaTestConfigurationBase) {
        Module module2 = ((JavaRunConfigurationModule)javaTestConfigurationBase.getConfigurationModule()).getModule();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        PathsList pathsList = (PathsList)ReadAction.compute(() -> (module2 == null || javaTestConfigurationBase.getTestSearchScope() == TestSearchScope.WHOLE_PROJECT ? OrderEnumerator.orderEntries((Project)javaTestConfigurationBase.getProject()) : OrderEnumerator.orderEntries((Module)module2)).runtimeOnly().recursively().getPathsList());
        for (VirtualFile virtualFile : pathsList.getVirtualFiles()) {
            try {
                arrayList.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                a.info((Throwable)malformedURLException);
            }
        }
        return UrlClassLoader.build().allowLock().useCache().urls(arrayList).get();
    }

    @Nullable
    public static Path getRootPath(Module module2, boolean bl2) {
        VirtualFile virtualFile;
        CompilerModuleExtension compilerModuleExtension;
        if (bl2 && (compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module2)) != null && (virtualFile = compilerModuleExtension.getCompilerOutputPathForTests()) != null) {
            return Paths.get(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toURI());
        }
        return null;
    }
}

