/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.ui.components.JBList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YourkitFilter
implements Filter {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.execution.filters.YourkitFilter");
    private final Project a;
    private static final Pattern b = Pattern.compile("\\s*(\\w*)\\(\\):(-?\\d*), (\\w*\\.java)\\n");

    public YourkitFilter(@NotNull Project project2) {
        if (project2 == null) {
            YourkitFilter.a(0);
        }
        this.a = project2;
    }

    public Filter.Result applyFilter(String string, int n2) {
        if (!string.endsWith(".java\n")) {
            return null;
        }
        try {
            Matcher matcher = b.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                int n3 = Integer.parseInt(matcher.group(2));
                String string3 = matcher.group(3);
                int n4 = n2 - string.length();
                PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)this.a);
                PsiFile[] psiFileArray = psiShortNamesCache.getFilesByName(string3);
                if (psiFileArray.length == 0) {
                    return null;
                }
                Object object = psiFileArray.length == 1 ? new OpenFileHyperlinkInfo(this.a, psiFileArray[0].getVirtualFile(), n3 - 1) : new MyHyperlinkInfo(psiFileArray);
                return new Filter.Result(n4 + matcher.start(2), n4 + matcher.end(3), (HyperlinkInfo)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            c.debug((Throwable)numberFormatException);
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/YourkitFilter", "<init>"));
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement psiElement) {
            return psiElement.getContainingFile().getName();
        }

        @Nullable
        protected String getContainerText(PsiElement psiElement, String string) {
            PsiDirectory psiDirectory = ((PsiFile)psiElement).getParent();
            if (psiDirectory == null) {
                return null;
            }
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
            if (psiPackage == null) {
                return null;
            }
            return "(" + psiPackage.getQualifiedName() + ")";
        }

        protected int getIconFlags() {
            return 0;
        }
    }

    private static class MyHyperlinkInfo
    implements HyperlinkInfo {
        private final PsiFile[] a;

        public MyHyperlinkInfo(PsiFile[] psiFileArray) {
            this.a = psiFileArray;
        }

        public void navigate(Project project2) {
            DefaultPsiElementListCellRenderer defaultPsiElementListCellRenderer = new DefaultPsiElementListCellRenderer();
            JBList jBList = new JBList((Object[])this.a);
            jBList.setCellRenderer(defaultPsiElementListCellRenderer);
            PopupChooserBuilder popupChooserBuilder = new PopupChooserBuilder((JList)jBList);
            defaultPsiElementListCellRenderer.installSpeedSearch(popupChooserBuilder);
            Runnable runnable = () -> MyHyperlinkInfo.a((JList)jBList);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
            popupChooserBuilder.setTitle("Choose file").setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
        }

        private static /* synthetic */ void a(JList jList) {
            Object[] objectArray;
            int[] nArray = jList.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            for (Object object : objectArray = jList.getSelectedValues()) {
                Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)((PsiElement)object));
                if (navigatable == null || !navigatable.canNavigate()) continue;
                navigatable.navigate(true);
            }
        }
    }
}

