/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellSyntheticElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteJShellAction
extends AnAction {
    private static final AnAction a = new ExecuteJShellAction();
    private boolean b = false;

    private ExecuteJShellAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(anActionEvent.getDataContext());
        if (editor == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(anActionEvent.getDataContext());
        if (virtualFile == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            Sdk sdk;
            Module module2;
            JShellHandler jShellHandler = JShellHandler.getAssociatedHandler(virtualFile);
            if (jShellHandler == null) {
                SnippetEditorDecorator.ConfigurationPane configurationPane = SnippetEditorDecorator.getJShellConfiguration(anActionEvent.getDataContext());
                module2 = configurationPane != null ? configurationPane.getContextModule() : null;
                sdk = configurationPane != null ? configurationPane.getRuntimeSdk() : null;
                jShellHandler = JShellHandler.create(project2, virtualFile, module2, sdk);
            }
            if (jShellHandler != null) {
                jShellHandler.toFront();
                boolean bl2 = false;
                module2 = editor.getDocument();
                sdk = EditorUtil.getSelectionInAnyMode((Editor)editor);
                if (sdk.isEmpty()) {
                    PsiElement psiElement = this.a(project2, anActionEvent);
                    if (psiElement instanceof PsiJShellFile) {
                        for (PsiElement psiElement2 : ((PsiJShellFile)psiElement).getExecutableSnippets()) {
                            bl2 |= ExecuteJShellAction.a(jShellHandler, psiElement2.getText());
                        }
                    } else if (psiElement != null) {
                        bl2 = ExecuteJShellAction.a(jShellHandler, psiElement.getText());
                    }
                } else {
                    bl2 = ExecuteJShellAction.a(jShellHandler, module2.getText((TextRange)sdk));
                }
                if (!bl2) {
                    JShellDiagnostic.notifyInfo("Nothing to execute", project2);
                }
            }
        }
        catch (Exception exception) {
            JShellDiagnostic.notifyError(exception, project2);
        }
    }

    private static boolean a(@NotNull JShellHandler jShellHandler, String string) {
        if (jShellHandler == null) {
            ExecuteJShellAction.a(0);
        }
        if (!StringUtil.isEmptyOrSpaces((String)string)) {
            jShellHandler.evaluate(string.trim());
            return true;
        }
        return false;
    }

    @Nullable
    private PsiElement a(Project project2, AnActionEvent anActionEvent) {
        PsiFile psiFile;
        Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) instanceof PsiJShellFile) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = this.b ? ExecuteJShellAction.a(psiFile, editor.getDocument(), editor.getCaretModel().getOffset()) : null;
            while (psiElement != null) {
                PsiElement psiElement3 = psiElement.getParent();
                if (psiElement3 instanceof PsiJShellHolderMethod && psiElement instanceof PsiEmptyStatement) {
                    psiElement = psiElement3.getPrevSibling();
                    if (!(psiElement instanceof PsiJShellSyntheticElement)) continue;
                    psiElement = psiElement.getFirstChild();
                    break;
                }
                if (psiElement3 instanceof PsiJShellSyntheticElement || psiElement3 instanceof PsiJShellFile) break;
                psiElement = psiElement3;
            }
            return psiElement != null ? psiElement : psiFile;
        }
        return null;
    }

    private static PsiElement a(PsiFile psiFile, Document document, int n2) {
        int n3 = DocumentUtil.getLineStartOffset((int)n2, (Document)document);
        PsiElement psiElement = null;
        for (int i2 = n2; i2 >= n3 && ((psiElement = psiFile.findElementAt(i2)) == null || psiElement instanceof PsiWhiteSpace); --i2) {
        }
        return psiElement;
    }

    public static AnAction getSharedInstance() {
        return a;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/jshell/ExecuteJShellAction", "scheduleEval"));
    }
}

