/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.TestDiscoveryListener;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryExtension
extends RunConfigurationExtension {
    private static final Logger b = Logger.getInstance(TestDiscoveryExtension.class);
    private static final Object a = new Object();

    @NotNull
    public String getSerializationId() {
        if ("testDiscovery" == null) {
            TestDiscoveryExtension.b(0);
        }
        return "testDiscovery";
    }

    protected void attachToProcess(final @NotNull RunConfigurationBase runConfigurationBase, final @NotNull ProcessHandler processHandler, @Nullable RunnerSettings runnerSettings) {
        if (runConfigurationBase == null) {
            TestDiscoveryExtension.b(1);
        }
        if (processHandler == null) {
            TestDiscoveryExtension.b(2);
        }
        if (runnerSettings == null && this.isApplicableFor(runConfigurationBase)) {
            final String string = ((JavaTestConfigurationBase)runConfigurationBase).getFrameworkPrefix();
            final String string2 = ((JavaRunConfigurationModule)((JavaTestConfigurationBase)runConfigurationBase).getConfigurationModule()).getModuleName();
            final Disposable disposable = Disposer.newDisposable();
            final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, disposable);
            final MessageBusConnection messageBusConnection = runConfigurationBase.getProject().getMessageBus().connect();
            messageBusConnection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new SMTRunnerEventsAdapter(){
                private List<String> a = new ArrayList<String>();

                public void onTestFinished(@NotNull SMTestProxy sMTestProxy) {
                    String string3;
                    SMTestProxy.SMRootTestProxy sMRootTestProxy;
                    if (sMTestProxy == null) {
                        1.a(0);
                    }
                    if (((sMRootTestProxy = sMTestProxy.getRoot()) == null || sMRootTestProxy.getHandler() == processHandler) && (string3 = sMTestProxy.getLocationUrl()) != null && string3.startsWith("java:test")) {
                        this.a.add(string + string3.substring("java:test".length() + 3));
                        if (this.a.size() > 50) {
                            String[] stringArray = ArrayUtil.toStringArray(this.a);
                            this.a.clear();
                            alarm.addRequest(() -> {
                                if (runConfigurationBase == null) {
                                    1.a(3);
                                }
                                TestDiscoveryExtension.processAvailableTraces(stringArray, TestDiscoveryExtension.a(runConfigurationBase), string2, string, TestDiscoveryIndex.getInstance(runConfigurationBase.getProject()));
                            }, 100);
                        }
                    }
                }

                public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy sMRootTestProxy) {
                    if (sMRootTestProxy == null) {
                        1.a(1);
                    }
                    if (sMRootTestProxy.getHandler() == processHandler) {
                        alarm.cancelAllRequests();
                        alarm.addRequest(() -> {
                            if (runConfigurationBase == null) {
                                1.a(2);
                            }
                            TestDiscoveryExtension.b(runConfigurationBase);
                            Disposer.dispose((Disposable)disposable);
                        }, 0);
                        messageBusConnection.disconnect();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "test";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "testsRoot";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "configuration";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestingFinished";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onTestingFinished$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onTestFinished$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public void updateJavaParameters(RunConfigurationBase runConfigurationBase, JavaParameters javaParameters, RunnerSettings runnerSettings) {
        if (runnerSettings != null || !this.isApplicableFor(runConfigurationBase)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("-javaagent:");
        String string = PathUtil.getJarPathForClass(TestDiscoveryProjectData.class);
        stringBuilder.append(string);
        javaParameters.getVMParametersList().add(stringBuilder.toString());
        javaParameters.getClassPath().add(string);
        javaParameters.getVMParametersList().addProperty("org.jetbrains.instrumentation.trace.dir", TestDiscoveryExtension.a(runConfigurationBase));
    }

    @NotNull
    private static String a(RunConfigurationBase runConfigurationBase) {
        String string = TestDiscoveryExtension.baseTestDiscoveryPathForProject(runConfigurationBase.getProject()) + File.separator + runConfigurationBase.getUniqueID();
        if (string == null) {
            TestDiscoveryExtension.b(3);
        }
        return string;
    }

    @Override
    public boolean isListenerDisabled(RunConfigurationBase runConfigurationBase, Object object, RunnerSettings runnerSettings) {
        return object instanceof TestDiscoveryListener && (runnerSettings != null || !this.isApplicableFor(runConfigurationBase));
    }

    public void readExternal(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Element element) throws InvalidDataException {
        if (runConfigurationBase == null) {
            TestDiscoveryExtension.b(4);
        }
        if (element == null) {
            TestDiscoveryExtension.b(5);
        }
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Element element) throws WriteExternalException {
        if (runConfigurationBase == null) {
            TestDiscoveryExtension.b(6);
        }
        if (element == null) {
            TestDiscoveryExtension.b(7);
        }
        throw new WriteExternalException();
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase runConfigurationBase) {
        if (runConfigurationBase == null) {
            TestDiscoveryExtension.b(8);
        }
        return runConfigurationBase instanceof JavaTestConfigurationBase && Registry.is((String)"testDiscovery.enabled");
    }

    @NotNull
    public static Path baseTestDiscoveryPathForProject(Project project2) {
        Path path = ProjectUtil.getProjectCachePath((Project)project2, (String)"testDiscovery", (boolean)true);
        if (path == null) {
            TestDiscoveryExtension.b(9);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RunConfigurationBase runConfigurationBase) {
        String string2 = TestDiscoveryExtension.a(runConfigurationBase);
        TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(runConfigurationBase.getProject());
        Object object = a;
        synchronized (object) {
            File file2 = new File(string2);
            File[] fileArray = file2.listFiles((file, string) -> string.endsWith(".tr"));
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    try {
                        testDiscoveryIndex.updateFromTestTrace(file3, ((JavaRunConfigurationModule)((JavaTestConfigurationBase)runConfigurationBase).getConfigurationModule()).getModuleName(), ((JavaTestConfigurationBase)runConfigurationBase).getFrameworkPrefix());
                        FileUtil.delete((File)file3);
                    }
                    catch (IOException iOException) {
                        b.error("Can not load " + file3, (Throwable)iOException);
                    }
                }
                Object[] objectArray = file2.list();
                if (objectArray == null || objectArray.length == 0) {
                    FileUtil.delete((File)file2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAvailableTraces(String[] stringArray, String string, String string2, String string3, TestDiscoveryIndex testDiscoveryIndex) {
        Object object = a;
        synchronized (object) {
            for (String string4 : stringArray) {
                File file;
                String string5 = StringUtil.getPackageName((String)string4);
                String string6 = StringUtil.getShortName((String)string4);
                if (StringUtil.isEmptyOrSpaces((String)string5) || StringUtil.isEmptyOrSpaces((String)string6) || !(file = new File(string, string5 + "-" + string6 + ".tr")).exists()) continue;
                try {
                    testDiscoveryIndex.updateFromTestTrace(file, string2, string3);
                    FileUtil.delete((File)file);
                }
                catch (Throwable throwable) {
                    b.error("Can not load " + file, throwable);
                }
            }
        }
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracesDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "baseTestDiscoveryPathForProject";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

