/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInClassConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T> {
    private static final Logger a = Logger.getInstance(AbstractInClassConfigurationProducer.class);

    protected AbstractInClassConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext configurationFromContext, @NotNull ConfigurationContext configurationContext, @NotNull Runnable runnable) {
        PsiElement psiElement;
        if (configurationFromContext == null) {
            AbstractInClassConfigurationProducer.a(0);
        }
        if (configurationContext == null) {
            AbstractInClassConfigurationProducer.a(1);
        }
        if (runnable == null) {
            AbstractInClassConfigurationProducer.a(2);
        }
        if ((psiElement = configurationFromContext.getSourceElement()) instanceof PsiMethod || psiElement instanceof PsiClass) {
            PsiClass psiClass2;
            PsiMethod psiMethod;
            if (psiElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)psiElement;
                psiClass2 = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                psiClass2 = (PsiClass)psiElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                @Override
                protected void runForClasses(List<PsiClass> list2, PsiMethod psiMethod, ConfigurationContext configurationContext, Runnable runnable) {
                    ((JavaTestConfigurationBase)configurationFromContext.getConfiguration()).bePatternConfiguration(list2, psiMethod);
                    super.runForClasses(list2, psiMethod, configurationContext, runnable);
                }

                @Override
                protected void runForClass(PsiClass psiClass, PsiMethod psiMethod, ConfigurationContext configurationContext, Runnable runnable) {
                    if (psiElement instanceof PsiMethod) {
                        Project project2 = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)psiClass));
                        ((JavaTestConfigurationBase)configurationFromContext.getConfiguration()).beMethodConfiguration(methodLocation);
                    } else {
                        ((JavaTestConfigurationBase)configurationFromContext.getConfiguration()).beClassConfiguration(psiClass);
                    }
                    super.runForClass(psiClass, psiMethod, configurationContext, runnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(configurationContext, runnable, psiMethod, psiClass2, (Condition<PsiClass>)((Condition)psiClass -> psiClass.hasModifierProperty("abstract") && this.isTestClass((PsiClass)psiClass)))) {
                return;
            }
        }
        super.onFirstRun(configurationFromContext, configurationContext, runnable);
    }

    protected boolean setupConfigurationFromContext(T t2, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        PsiClass psiClass;
        if (this.isMultipleElementsSelected(configurationContext)) {
            return false;
        }
        Location location = configurationContext.getLocation();
        this.setupConfigurationParamName(t2, location);
        PsiClass psiClass2 = null;
        for (PsiElement psiElement = configurationContext.getPsiLocation(); psiElement != null; psiElement = psiElement.getParent()) {
            if (psiElement instanceof PsiClass && this.isTestClass((PsiClass)psiElement)) {
                psiClass2 = (PsiClass)psiElement;
                break;
            }
            if (psiElement instanceof PsiMember) {
                PsiClass psiClass3 = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (psiClass2 = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiElement).getContainingClass());
                if (!this.isTestClass(psiClass2)) continue;
                break;
            }
            if (!(psiElement instanceof PsiClassOwner) || ((PsiClass)(psiClass = ((PsiClassOwner)psiElement).getClasses())).length != 1) continue;
            psiClass2 = psiClass[0];
            break;
        }
        if (!this.isTestClass(psiClass2)) {
            return false;
        }
        psiClass = psiClass2;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.cloneTemplateConfiguration(configurationContext);
        this.setupConfigurationModule(configurationContext, t2);
        Module module2 = ((JavaRunConfigurationModule)t2.getConfigurationModule()).getModule();
        ((JavaTestConfigurationBase)t2).beClassConfiguration(psiClass2);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)configurationContext.getPsiLocation(), PsiMethod.class, (boolean)false);
        while (psiMethod != null) {
            if (this.isTestMethod(false, psiMethod)) {
                ((JavaTestConfigurationBase)t2).beMethodConfiguration(MethodLocation.elementInClass(psiMethod, psiClass2));
                psiClass = psiMethod;
            }
            psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiMethod.class);
        }
        t2.restoreOriginalModule(module2);
        a.assertTrue(((JavaRunConfigurationModule)t2.getConfigurationModule()).getModule() != null);
        runnerAndConfigurationSettings.setName(t2.getName());
        ref.set((Object)psiClass);
        return true;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fromContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "performRunnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/testframework/AbstractInClassConfigurationProducer";
        objectArray[2] = "onFirstRun";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

