/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractJavaTestConfigurationProducer<T extends JavaTestConfigurationBase>
extends JavaRunConfigurationProducerBase<T> {
    protected AbstractJavaTestConfigurationProducer(ConfigurationFactory configurationFactory) {
        super(configurationFactory);
    }

    protected AbstractJavaTestConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean isTestClass(PsiClass psiClass) {
        if (psiClass != null) {
            JavaTestFramework javaTestFramework = this.getCurrentFramework(psiClass);
            return javaTestFramework != null && javaTestFramework.isTestClass((PsiElement)psiClass);
        }
        return false;
    }

    protected boolean isTestMethod(boolean bl2, PsiMethod psiMethod) {
        JavaTestFramework javaTestFramework = this.getCurrentFramework(psiMethod.getContainingClass());
        return javaTestFramework != null && javaTestFramework.isTestMethod((PsiElement)psiMethod, bl2);
    }

    protected JavaTestFramework getCurrentFramework(PsiClass psiClass) {
        if (psiClass != null) {
            ConfigurationType configurationType = this.getConfigurationType();
            Set set = TestFrameworks.detectApplicableFrameworks((PsiClass)psiClass);
            return set.stream().filter(testFramework -> testFramework instanceof JavaTestFramework && ((JavaTestFramework)testFramework).isMyConfigurationType(configurationType)).map(testFramework -> (JavaTestFramework)testFramework).findFirst().orElse(null);
        }
        return null;
    }

    public boolean isConfigurationFromContext(T t2, ConfigurationContext configurationContext) {
        String string;
        if (this.isMultipleElementsSelected(configurationContext)) {
            return false;
        }
        RunConfiguration runConfiguration = configurationContext.getOriginalConfiguration(this.getConfigurationType());
        Location location = configurationContext.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (location2 == null) {
            return false;
        }
        PsiElement psiElement = location2.getPsiElement();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)location2.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        Module module2 = ((JavaRunConfigurationModule)((JavaTestConfigurationBase)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule()).getModule();
        String string2 = string = runConfiguration instanceof CommonJavaRunConfigurationParameters ? ((CommonJavaRunConfigurationParameters)runConfiguration).getVMParameters() : null;
        if (string != null && !Comparing.strEqual((String)string, (String)t2.getVMParameters())) {
            return false;
        }
        if (this.differentParamSet(t2, location)) {
            return false;
        }
        if (((JavaTestConfigurationBase)t2).isConfiguredByElement(psiElement)) {
            Module module3 = ((JavaRunConfigurationModule)t2.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location2.getModule(), (Object)module3)) {
                return true;
            }
            if (Comparing.equal((Object)module2, (Object)module3)) {
                return true;
            }
        }
        return false;
    }

    protected boolean differentParamSet(T t2, Location location) {
        String string;
        String string2 = string = location instanceof PsiMemberParameterizedLocation ? ((JavaTestConfigurationBase)t2).prepareParameterizedParameter(((PsiMemberParameterizedLocation)location).getParamSetName()) : null;
        return string != null && !Comparing.strEqual((String)string, (String)t2.getProgramParameters());
    }

    public Module findModule(ModuleBasedConfiguration moduleBasedConfiguration, Module module2, Set<String> set) {
        return JavaExecutionUtil.findModule((Module)module2, set, (Project)moduleBasedConfiguration.getProject(), psiClass -> this.isTestClass((PsiClass)psiClass));
    }

    public void collectTestMembers(PsiElement[] psiElementArray, boolean bl2, boolean bl3, PsiElementProcessor.CollectElements<PsiElement> collectElements) {
        for (PsiElement psiElement : psiElementArray) {
            PsiClass psiClass;
            if (psiElement instanceof PsiClassOwner) {
                for (PsiClass psiClass2 : psiClass = ((PsiClassOwner)psiElement).getClasses()) {
                    if ((bl3 || !psiClass2.hasModifierProperty("public")) && (!bl3 || !this.isTestClass(psiClass2)) || collectElements.execute((PsiElement)psiClass2)) continue;
                    return;
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if ((bl3 || !((PsiClass)psiElement).hasModifierProperty("public")) && (!bl3 || !this.isTestClass((PsiClass)psiElement)) || collectElements.execute(psiElement)) continue;
                return;
            }
            if (psiElement instanceof PsiMethod) {
                if (bl3 && this.isTestMethod(bl2, (PsiMethod)psiElement) && !collectElements.execute(psiElement)) {
                    return;
                }
                if (bl3 || (psiClass = ((PsiMethod)psiElement).getContainingClass()) == null || !psiClass.hasModifierProperty("public") || collectElements.execute(psiElement)) continue;
                return;
            }
            if (!(psiElement instanceof PsiDirectory) || (psiClass = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) == null || collectElements.execute((PsiElement)psiClass)) continue;
            return;
        }
    }

    protected boolean collectContextElements(DataContext dataContext, boolean bl2, boolean bl3, LinkedHashSet<String> linkedHashSet, PsiElementProcessor.CollectElements<PsiElement> collectElements) {
        PsiManager psiManager;
        List list2;
        VirtualFile[] virtualFileArray;
        PsiElement[] psiElementArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (psiElementArray != null) {
            return this.a(psiElementArray, bl2, bl3, collectElements, linkedHashSet);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement psiElement = null;
        if (editor != null) {
            virtualFileArray = (VirtualFile[])CommonDataKeys.PSI_FILE.getData(dataContext);
            list2 = editor.getCaretModel().getAllCarets();
            if (virtualFileArray != null) {
                if (list2.size() > 1) {
                    psiManager = new LinkedHashSet();
                    for (Caret caret : list2) {
                        ContainerUtil.addIfNotNull((Collection)psiManager, (Object)PsiTreeUtil.getParentOfType((PsiElement)virtualFileArray.findElementAt(caret.getOffset()), PsiMethod.class));
                    }
                    if (!psiManager.isEmpty()) {
                        return this.a(psiManager.toArray(PsiElement.EMPTY_ARRAY), bl2, bl3, collectElements, linkedHashSet);
                    }
                } else {
                    int n2;
                    Caret caret;
                    psiElement = virtualFileArray.findElementAt(editor.getCaretModel().getOffset());
                    psiManager = editor.getSelectionModel();
                    if (psiManager.hasSelection() && (caret = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)virtualFileArray.findElementAt(n2 = psiManager.getSelectionStart()), PsiClass.class)) != null) {
                        TextRange textRange = new TextRange(n2, psiManager.getSelectionEnd());
                        PsiMethod[] psiMethodArray = (PsiMethod[])Arrays.stream(caret.getMethods()).filter(psiMethod -> {
                            TextRange textRange2 = psiMethod.getTextRange();
                            return textRange2 != null && textRange.contains(textRange2);
                        }).toArray(PsiMethod[]::new);
                        if (psiMethodArray.length > 0) {
                            return this.a((PsiElement[])psiMethodArray, bl2, bl3, collectElements, linkedHashSet);
                        }
                    }
                }
            }
        }
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if ((virtualFileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && (list2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            psiManager = PsiManager.getInstance((Project)list2);
            for (VirtualFile virtualFile : virtualFileArray) {
                PsiFile psiFile = psiManager.findFile(virtualFile);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                PsiClass[] psiClassArray = ((PsiClassOwner)psiFile).getClasses();
                if (psiElement != null && psiClassArray.length > 0) {
                    for (PsiClass psiClass : psiClassArray) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)psiElement, (boolean)false)) continue;
                        psiClassArray = new PsiClass[]{psiClass};
                        break;
                    }
                }
                this.collectTestMembers((PsiElement[])psiClassArray, bl2, bl3, collectElements);
                for (PsiElement psiElement2 : collectElements.getCollection()) {
                    linkedHashSet.add(((PsiClass)psiElement2).getQualifiedName());
                }
            }
            return true;
        }
        return false;
    }

    private boolean a(PsiElement[] psiElementArray, boolean bl2, boolean bl3, PsiElementProcessor.CollectElements<PsiElement> collectElements, LinkedHashSet<String> linkedHashSet) {
        this.collectTestMembers(psiElementArray, bl2, bl3, collectElements);
        for (PsiElement psiElement : collectElements.getCollection()) {
            linkedHashSet.add(this.getQName(psiElement));
        }
        return linkedHashSet.size() > 1;
    }

    protected PsiElement[] collectLocationElements(LinkedHashSet<String> linkedHashSet, DataContext dataContext) {
        Location[] locationArray = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locationArray != null) {
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            for (Location location : locationArray) {
                String string;
                PsiElement psiElement = location.getPsiElement();
                if (!(psiElement instanceof PsiNamedElement) || (string = this.getQName(psiElement, location)) == null) continue;
                linkedHashSet.add(string);
                arrayList.add(psiElement);
            }
            return arrayList.toArray(PsiElement.EMPTY_ARRAY);
        }
        return null;
    }

    public String getQName(PsiElement psiElement) {
        return this.getQName(psiElement, null);
    }

    public String getQName(PsiElement psiElement, Location location) {
        if (psiElement instanceof PsiClass) {
            return ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiElement));
        }
        if (psiElement instanceof PsiMember) {
            PsiClass psiClass;
            PsiClass psiClass2 = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (psiClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiElement).getContainingClass());
            assert (psiClass != null);
            return ClassUtil.getJVMClassName((PsiClass)psiClass) + "," + this.getMethodPresentation((PsiMember)psiElement);
        }
        if (psiElement instanceof PsiPackage) {
            return ((PsiPackage)psiElement).getQualifiedName() + ".*";
        }
        return null;
    }

    protected String getMethodPresentation(PsiMember psiMember) {
        return psiMember.getName();
    }

    public boolean isMultipleElementsSelected(ConfigurationContext configurationContext) {
        if (!configurationContext.containsMultipleSelection()) {
            return false;
        }
        DataContext dataContext = configurationContext.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)dataContext)) {
            return false;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        PsiElementProcessor.CollectElementsWithLimit collectElementsWithLimit = new PsiElementProcessor.CollectElementsWithLimit(2);
        PsiElement[] psiElementArray = this.collectLocationElements(linkedHashSet, dataContext);
        if (psiElementArray != null) {
            this.collectTestMembers(psiElementArray, false, false, (PsiElementProcessor.CollectElements<PsiElement>)collectElementsWithLimit);
        } else {
            this.collectContextElements(dataContext, false, false, linkedHashSet, (PsiElementProcessor.CollectElements<PsiElement>)collectElementsWithLimit);
        }
        return collectElementsWithLimit.getCollection().size() > 1;
    }

    public void setupConfigurationParamName(T t2, Location location) {
        String string;
        if (location instanceof PsiMemberParameterizedLocation && (string = ((PsiMemberParameterizedLocation)location).getParamSetName()) != null) {
            t2.setProgramParameters(((JavaTestConfigurationBase)t2).prepareParameterizedParameter(string));
        }
    }
}

