/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    private static final Logger b = Logger.getInstance(SearchForTestsTask.class);
    protected Socket mySocket;
    private ServerSocket c;
    private ProgressIndicator a;

    public SearchForTestsTask(@Nullable Project project2, ServerSocket serverSocket) {
        super(project2, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.c = serverSocket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.a != null && !this.a.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.search();
            }
            catch (Throwable throwable) {
                b.error(throwable);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException executionException) {
                b.error((Throwable)executionException);
            }
        } else {
            this.a = new BackgroundableProcessIndicator((Task.Backgroundable)this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.a);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler oSProcessHandler) {
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    1.a(0);
                }
                oSProcessHandler.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    1.a(1);
                }
                SearchForTestsTask.this.startSearch();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void run(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            SearchForTestsTask.a(0);
        }
        try {
            this.mySocket = this.c.accept();
            ExecutionException[] executionExceptionArray = new ExecutionException[1];
            Runnable runnable = () -> {
                try {
                    this.search();
                }
                catch (ExecutionException executionException) {
                    executionExceptionArray[0] = executionException;
                }
            };
            if (Registry.is((String)"junit4.search.4.tests.in.classpath", (boolean)false)) {
                runnable.run();
            } else {
                while (!this.a(runnable, (ProgressIndicator)new SensitiveProgressWrapper(progressIndicator))) {
                }
            }
            if (executionExceptionArray[0] != null) {
                this.logCantRunException(executionExceptionArray[0]);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
        }
        catch (Throwable throwable) {
            b.error(throwable);
        }
    }

    private boolean a(@NotNull Runnable runnable, ProgressIndicator progressIndicator) {
        if (runnable == null) {
            SearchForTestsTask.a(1);
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        progressIndicator.checkCanceled();
        dumbService.waitForSmartMode();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (runnable == null) {
                SearchForTestsTask.a(2);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (dumbService.isDumb()) {
                atomicBoolean.set(true);
                return;
            }
            runnable.run();
        }, (ProgressIndicator)progressIndicator);
        if (atomicBoolean.get()) {
            return false;
        }
        if (!bl2) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return bl2;
    }

    protected void logCantRunException(ExecutionException executionException) throws ExecutionException {
        throw executionException;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        Runnable runnable = () -> {
            try {
                this.onFound();
            }
            catch (ExecutionException executionException) {
                b.error((Throwable)executionException);
            }
            this.finish();
        };
        if (Registry.is((String)"junit4.search.4.tests.in.classpath", (boolean)false)) {
            runnable.run();
        } else {
            DumbService.getInstance((Project)this.getProject()).runWhenSmart(runnable);
        }
    }

    public void finish() {
        FilterOutputStream filterOutputStream = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            filterOutputStream = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBoolean(true);
        }
        catch (Throwable throwable) {
            b.info(throwable);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                b.info(throwable);
            }
            try {
                if (!this.c.isClosed()) {
                    this.c.close();
                }
            }
            catch (Throwable throwable) {
                b.info(throwable);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runSmartModeReadActionWithWritePriority";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runSmartModeReadActionWithWritePriority$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

