/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser
extends BrowseModuleValueActionListener {
    private final String a;

    public ClassBrowser(Project project2, String string) {
        super(project2);
        this.a = string;
    }

    @Nullable
    protected String showDialog() {
        ClassFilter.ClassFilterWithScope classFilterWithScope;
        try {
            classFilterWithScope = this.getFilter();
        }
        catch (NoFilterException noFilterException) {
            MessagesEx.MessageInfo messageInfo = noFilterException.getMessageInfo();
            messageInfo.showNow();
            return null;
        }
        TreeClassChooser treeClassChooser = this.createClassChooser(classFilterWithScope);
        this.a(treeClassChooser);
        treeClassChooser.showDialog();
        PsiClass psiClass = treeClassChooser.getSelected();
        if (psiClass == null) {
            return null;
        }
        this.onClassChoosen(psiClass);
        return psiClass.getQualifiedName();
    }

    protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilterWithScope) {
        return TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser(this.a, classFilterWithScope.getScope(), (ClassFilter)classFilterWithScope, null);
    }

    protected abstract ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException;

    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void a(TreeClassChooser treeClassChooser) {
        String string = this.getText();
        PsiClass psiClass = this.findClass(string);
        if (psiClass == null) {
            return;
        }
        PsiDirectory psiDirectory = psiClass.getContainingFile().getContainingDirectory();
        if (psiDirectory != null) {
            treeClassChooser.selectDirectory(psiDirectory);
        }
        treeClassChooser.select(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    public static ClassBrowser createApplicationClassBrowser(Project project2, ConfigurationModuleSelector configurationModuleSelector) {
        final ClassFilter classFilter = new ClassFilter(){

            public boolean isAccepted(PsiClass psiClass) {
                return ConfigurationUtil.MAIN_CLASS.value((Object)psiClass) && this.a(psiClass) != null;
            }

            @Nullable
            private PsiMethod a(final PsiClass psiClass) {
                return (PsiMethod)new ReadAction<PsiMethod>(){

                    protected void run(@NotNull Result<PsiMethod> result2) throws Throwable {
                        if (result2 == null) {
                            1.a(0);
                        }
                        result2.setResult((Object)PsiMethodUtil.findMainMethod((PsiClass)psiClass));
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/execution/ui/ClassBrowser$1$1", "run"));
                    }
                }.execute().getResultObject();
            }
        };
        return new MainClassBrowser(project2, configurationModuleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            @Override
            protected ClassFilter createFilter(Module module2) {
                return classFilter;
            }
        };
    }

    public static ClassBrowser createAppletClassBrowser(final Project project2, final ConfigurationModuleSelector configurationModuleSelector) {
        final String string = ExecutionBundle.message((String)"choose.applet.class.dialog.title", (Object[])new Object[0]);
        return new MainClassBrowser(project2, configurationModuleSelector, string){

            @Override
            protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilterWithScope) {
                Module module2 = configurationModuleSelector.getModule();
                GlobalSearchScope globalSearchScope = module2 == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.applet.Applet", globalSearchScope);
                return TreeClassChooserFactory.getInstance((Project)this.getProject()).createInheritanceClassChooser(string, classFilterWithScope.getScope(), psiClass, false, false, ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS);
            }
        };
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo a;

        public NoFilterException(MessagesEx.MessageInfo messageInfo) {
            super(messageInfo.getMessage());
            this.a = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.a;
        }

        public static NoFilterException noJUnitInModule(Module module2) {
            return new NoFilterException(new MessagesEx.MessageInfo(module2.getProject(), ExecutionBundle.message((String)"junit.not.found.in.module.error.message", (Object[])new Object[]{module2.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }

        public static NoFilterException moduleDoesntExist(ConfigurationModuleSelector configurationModuleSelector) {
            Project project2 = configurationModuleSelector.getProject();
            String string = configurationModuleSelector.getModuleName();
            return new NoFilterException(new MessagesEx.MessageInfo(project2, string.isEmpty() ? "No module selected" : ExecutionBundle.message((String)"module.does.not.exists", (Object[])new Object[]{string, project2.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }
    }

    public static abstract class MainClassBrowser
    extends ClassBrowser {
        protected final Project myProject;
        private final ConfigurationModuleSelector b;

        public MainClassBrowser(Project project2, ConfigurationModuleSelector configurationModuleSelector, String string) {
            super(project2, string);
            this.myProject = project2;
            this.b = configurationModuleSelector;
        }

        @Override
        protected PsiClass findClass(String string) {
            return this.b.findClass(string);
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException {
            Module module2 = this.b.getModule();
            final GlobalSearchScope globalSearchScope = module2 == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
            final ClassFilter classFilter = this.createFilter(module2);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return globalSearchScope;
                }

                public boolean isAccepted(PsiClass psiClass) {
                    return classFilter == null || classFilter.isAccepted(psiClass);
                }
            };
        }

        protected ClassFilter createFilter(Module module2) {
            return null;
        }
    }
}

