/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrePathEditor
extends JPanel
implements PanelWithAnchor {
    private static final String i = "Default";
    private final ComboboxWithBrowseButton a;
    private final JBLabel c = new JBLabel(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
    private final JreComboboxEditor e;
    private final DefaultJreItem h;
    private DefaultJreSelector f;
    private JComponent g;
    private final SortedComboBoxModel<JreComboBoxItem> d = new SortedComboBoxModel((jreComboBoxItem, jreComboBoxItem2) -> {
        int n2 = Comparing.compare((int)jreComboBoxItem.getOrder(), (int)jreComboBoxItem2.getOrder());
        if (n2 != 0) {
            return n2;
        }
        return jreComboBoxItem.getPresentableText().compareToIgnoreCase(jreComboBoxItem2.getPresentableText());
    });
    private String b;

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        String string;
        this.h = new DefaultJreItem();
        this.d.add((Object)this.h);
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        for (Sdk sdk : sdkArray) {
            this.d.add((Object)new SdkAsJreItem(sdk));
        }
        HashSet hashSet = new HashSet();
        for (JreProvider jreProvider : (ComboBox)JreProvider.EP_NAME.getExtensions()) {
            string = jreProvider.getJrePath();
            if (StringUtil.isEmpty((String)string)) continue;
            hashSet.add(string);
            this.d.add((Object)new CustomJreItem(string));
        }
        for (JreProvider jreProvider : sdkArray) {
            File file;
            string = jreProvider.getHomePath();
            if (!SystemInfo.isMac && (file = new File(jreProvider.getHomePath(), "jre")).isDirectory()) {
                string = file.getPath();
            }
            if (!hashSet.add(string)) continue;
            this.d.add((Object)new CustomJreItem(string));
        }
        ComboBox comboBox = new ComboBox(this.d, 100);
        comboBox.setEditable(true);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> jList, JreComboBoxItem jreComboBoxItem, int n2, boolean bl2, boolean bl3) {
                if (jList == null) {
                    1.a(0);
                }
                if (jreComboBoxItem != null) {
                    jreComboBoxItem.render((SimpleColoredComponent)this, bl2);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$1", "customizeCellRenderer"));
            }
        });
        this.e = new JreComboboxEditor(this.d);
        this.e.getEditorComponent().setTextToTriggerEmptyTextStatus(i);
        comboBox.setEditor((ComboBoxEditor)this.e);
        this.a = new ComboboxWithBrowseButton((JComboBox)comboBox);
        this.a.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 10, fill, flowx"));
        this.add((Component)this.c, "shrinkx");
        this.add((Component)this.a, "growx, pushx");
        InsertPathAction.addTo((JTextComponent)this.e.getEditorComponent());
        this.setAnchor((JComponent)this.c);
        this.updateUI();
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jreComboBoxItem = this.b();
        if (jreComboBoxItem instanceof DefaultJreItem) {
            return this.b;
        }
        return jreComboBoxItem.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        return !(this.b() instanceof DefaultJreItem);
    }

    private JreComboBoxItem b() {
        return (JreComboBoxItem)this.a.getComboBox().getEditor().getItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.f = defaultJreSelector;
        this.f.addChangeListener(() -> this.a());
    }

    public void setPathOrName(@Nullable String string, boolean bl2) {
        JreComboBoxItem jreComboBoxItem = this.h;
        if (!StringUtil.isEmpty((String)string)) {
            this.b = string;
            JreComboBoxItem jreComboBoxItem2 = this.a(string);
            if (bl2) {
                jreComboBoxItem = jreComboBoxItem2;
            }
        }
        ((JComboBox)this.a.getChildComponent()).setSelectedItem(jreComboBoxItem);
        this.a();
    }

    private void a() {
        StatusText statusText = this.e.getEmptyText();
        statusText.clear();
        statusText.appendText(i, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        statusText.appendText(this.f.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private JreComboBoxItem a(@NotNull String string) {
        if (string == null) {
            JrePathEditor.a(0);
        }
        for (JreComboBoxItem jreComboBoxItem : this.d.getItems()) {
            if ((!(jreComboBoxItem instanceof CustomJreItem) || !FileUtil.pathsEqual((String)string, (String)((CustomJreItem)jreComboBoxItem).a)) && !string.equals(jreComboBoxItem.getPathOrName())) continue;
            return jreComboBoxItem;
        }
        CustomJreItem customJreItem = new CustomJreItem(string);
        this.d.add((Object)customJreItem);
        return customJreItem;
    }

    public JComponent getAnchor() {
        return this.g;
    }

    public void setAnchor(JComponent jComponent) {
        this.g = jComponent;
        this.c.setAnchor(jComponent);
    }

    public void addActionListener(ActionListener actionListener) {
        this.a.getComboBox().addActionListener(actionListener);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathOrName", "com/intellij/execution/ui/JrePathEditor", "findOrAddCustomJre"));
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            simpleColoredComponent.append(JrePathEditor.i);
            if (JrePathEditor.this.f != null) {
                simpleColoredComponent.append(JrePathEditor.this.f.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public String getPresentableText() {
            return JrePathEditor.i;
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        private final String a;

        public CustomJreItem(String string) {
            this.a = string;
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            simpleColoredComponent.append(this.getPresentableText());
            simpleColoredComponent.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        public String getPresentableText() {
            return FileUtil.toSystemDependentName((String)this.a);
        }

        @Override
        public String getPathOrName() {
            return this.a;
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk a;

        public SdkAsJreItem(Sdk sdk) {
            this.a = sdk;
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            OrderEntryAppearanceService.getInstance().forJdk(this.a, false, bl2, true).customize(simpleColoredComponent);
        }

        @Override
        public String getPresentableText() {
            return this.a.getName();
        }

        @Override
        public String getPathOrName() {
            return this.a.getName();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @Nullable
        public String getPathOrName();

        public int getOrder();
    }
}

