/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.facet.impl.ui.FacetTreeModel;
import com.intellij.facet.impl.ui.ProjectConfigurableContext;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFacetsConfigurator
implements FacetsProvider {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetsConfigurator");
    private final Map<Module, ModifiableFacetModel> i = new HashMap<Module, ModifiableFacetModel>();
    private final Map<Facet, FacetEditorImpl> c = new LinkedHashMap<Facet, FacetEditorImpl>();
    private final Map<Module, FacetTreeModel> l = new HashMap<Module, FacetTreeModel>();
    private final Map<FacetInfo, Facet> k = new HashMap<FacetInfo, Facet>();
    private final Map<Facet, FacetInfo> f = new HashMap<Facet, FacetInfo>();
    private final Map<Module, UserDataHolder> h = new HashMap<Module, UserDataHolder>();
    private final Set<Facet> g = new HashSet<Facet>();
    private final Set<Facet> e = new HashSet<Facet>();
    private final Set<Facet> j = new HashSet<Facet>();
    private final StructureConfigurableContext d;
    private UserDataHolderBase b = new UserDataHolderBase();

    public ProjectFacetsConfigurator(StructureConfigurableContext structureConfigurableContext, ProjectFacetsConfigurator projectFacetsConfigurator) {
        this.d = structureConfigurableContext;
        if (projectFacetsConfigurator != null) {
            this.a(projectFacetsConfigurator);
        }
    }

    private void a(ProjectFacetsConfigurator projectFacetsConfigurator) {
        this.f.putAll(projectFacetsConfigurator.f);
        this.k.putAll(projectFacetsConfigurator.k);
        this.l.putAll(projectFacetsConfigurator.l);
        this.c.putAll(projectFacetsConfigurator.c);
    }

    public List<Facet> removeFacet(Facet facet) {
        FacetTreeModel facetTreeModel = this.getTreeModel(facet.getModule());
        FacetInfo facetInfo = this.f.get(facet);
        if (facetInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> arrayList = new ArrayList<Facet>();
        List<FacetInfo> list2 = facetTreeModel.getChildren(facetInfo);
        FacetInfo[] facetInfoArray = list2.toArray(FacetInfo.EMPTY_ARRAY);
        Object object = facetInfoArray;
        int n2 = ((FacetInfo[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FacetInfo facetInfo2 = object[i2];
            Facet facet2 = this.k.get(facetInfo2);
            if (facet2 == null) continue;
            arrayList.addAll(this.removeFacet(facet2));
        }
        facetTreeModel.removeFacetInfo(facetInfo);
        this.getOrCreateModifiableModel(facet.getModule()).removeFacet(facet);
        this.e.remove(facet);
        if (this.j.contains(facet)) {
            Disposer.dispose((Disposable)facet);
        }
        if ((object = this.c.remove(facet)) != null) {
            ((FacetEditorImpl)((Object)object)).disposeUIResources();
        }
        this.f.remove(facet);
        this.k.remove(facetInfo);
        arrayList.add(facet);
        return arrayList;
    }

    public Facet createAndAddFacet(Module module2, FacetType<?, ?> facetType, @Nullable Facet facet) {
        Collection collection = this.getFacetsByType(module2, facetType.getId());
        String string = facetType.getDefaultFacetName();
        int n2 = 2;
        while (this.a(string, collection)) {
            string = facetType.getDefaultFacetName() + n2;
            ++n2;
        }
        Facet facet2 = FacetManager.getInstance((Module)module2).createFacet(facetType, string, facet);
        this.j.add(facet2);
        this.addFacetInfo(facet2);
        this.getOrCreateModifiableModel(module2).addFacet(facet2);
        return facet2;
    }

    private boolean a(String string, Collection<? extends Facet> collection) {
        for (Facet facet : collection) {
            if (!this.getFacetName(facet).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addFacetInfo(Facet facet) {
        FacetInfo facetInfo = this.f.get(facet);
        if (facetInfo != null) {
            a.assertTrue(facetInfo.getName().equals(facet.getName()));
            a.assertTrue(facetInfo.getFacetType().equals(facet.getType()));
            a.assertTrue(facetInfo.getConfiguration().equals(facet.getConfiguration()));
            return;
        }
        FacetInfo facetInfo2 = new FacetInfo(facet.getType(), facet.getName(), facet.getConfiguration(), this.f.get(facet.getUnderlyingFacet()));
        this.f.put(facet, facetInfo2);
        this.k.put(facetInfo2, facet);
        this.getTreeModel(facet.getModule()).addFacetInfo(facetInfo2);
    }

    public void addFacetInfos(Module module2) {
        Facet[] facetArray;
        for (Facet facet : facetArray = this.getFacetModel(module2).getSortedFacets()) {
            this.addFacetInfo(facet);
        }
    }

    public void clearMaps() {
        this.i.clear();
        this.c.clear();
        this.l.clear();
        this.k.clear();
        this.f.clear();
        this.e.clear();
        this.h.clear();
    }

    private boolean a(Facet facet) {
        ModifiableFacetModel modifiableFacetModel = this.i.get(facet.getModule());
        return modifiableFacetModel != null && modifiableFacetModel.isNewFacet(facet);
    }

    @NotNull
    public ModifiableFacetModel getOrCreateModifiableModel(Module module2) {
        ModifiableFacetModel modifiableFacetModel = this.i.get(module2);
        if (modifiableFacetModel == null) {
            modifiableFacetModel = FacetManager.getInstance((Module)module2).createModifiableModel();
            this.i.put(module2, modifiableFacetModel);
        }
        ModifiableFacetModel modifiableFacetModel2 = modifiableFacetModel;
        if (modifiableFacetModel2 == null) {
            ProjectFacetsConfigurator.a(0);
        }
        return modifiableFacetModel2;
    }

    @Nullable
    public FacetEditorImpl getEditor(Facet facet) {
        return this.c.get(facet);
    }

    @NotNull
    public FacetEditorImpl getOrCreateEditor(Facet facet) {
        FacetEditorImpl facetEditorImpl = this.c.get(facet);
        if (facetEditorImpl == null) {
            Facet facet2 = facet.getUnderlyingFacet();
            FacetEditorContext facetEditorContext = facet2 != null ? this.getOrCreateEditor(facet2).getContext() : null;
            FacetEditorContext facetEditorContext2 = this.createContext(facet, facetEditorContext);
            facetEditorImpl = new FacetEditorImpl(facetEditorContext2, facet.getConfiguration());
            facetEditorImpl.getComponent();
            facetEditorImpl.reset();
            this.c.put(facet, facetEditorImpl);
        }
        FacetEditorImpl facetEditorImpl2 = facetEditorImpl;
        if (facetEditorImpl2 == null) {
            ProjectFacetsConfigurator.a(1);
        }
        return facetEditorImpl2;
    }

    protected FacetEditorContext createContext(@NotNull Facet facet, @Nullable FacetEditorContext facetEditorContext) {
        if (facet == null) {
            ProjectFacetsConfigurator.a(2);
        }
        Module module2 = facet.getModule();
        ModulesConfigurator modulesConfigurator = this.d.getModulesConfigurator();
        ModuleEditor moduleEditor = modulesConfigurator.getModuleEditor(module2);
        if (moduleEditor == null) {
            a.error("ModuleEditor[" + module2.getName() + "]==null: disposed = " + module2.isDisposed() + ", is in model = " + Arrays.asList(modulesConfigurator.getModules()).contains(module2));
        }
        ModuleConfigurationState moduleConfigurationState = moduleEditor.createModuleConfigurationState();
        return new MyProjectConfigurableContext(facet, facetEditorContext, moduleConfigurationState);
    }

    private UserDataHolder a(Module module2) {
        UserDataHolder userDataHolder = this.h.get(module2);
        if (userDataHolder == null) {
            userDataHolder = new UserDataHolderBase();
            this.h.put(module2, userDataHolder);
        }
        return userDataHolder;
    }

    @NotNull
    public FacetModel getFacetModel(Module module2) {
        ModifiableFacetModel modifiableFacetModel = this.i.get(module2);
        if (modifiableFacetModel != null) {
            ModifiableFacetModel modifiableFacetModel2 = modifiableFacetModel;
            if (modifiableFacetModel2 == null) {
                ProjectFacetsConfigurator.a(3);
            }
            return modifiableFacetModel2;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        if (facetManager == null) {
            ProjectFacetsConfigurator.a(4);
        }
        return facetManager;
    }

    public void commitFacets() {
        for (ModifiableFacetModel object : this.i.values()) {
            object.commit();
        }
        for (Map.Entry entry : this.c.entrySet()) {
            ((FacetEditorImpl)((Object)entry.getValue())).onFacetAdded((Facet)entry.getKey());
        }
        this.i.clear();
        for (Facet facet : this.e) {
            Module module2 = facet.getModule();
            if (module2.isDisposed()) continue;
            ((FacetManagerListener)module2.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
        }
        this.e.clear();
    }

    public void resetEditors() {
        for (FacetEditorImpl facetEditorImpl : this.c.values()) {
            facetEditorImpl.reset();
        }
    }

    public void applyEditors() throws ConfigurationException {
        for (Map.Entry<Facet, FacetEditorImpl> entry : this.c.entrySet()) {
            FacetEditorImpl facetEditorImpl = entry.getValue();
            if (facetEditorImpl.isModified()) {
                this.e.add(entry.getKey());
            }
            facetEditorImpl.apply();
        }
    }

    public boolean isModified() {
        for (ModifiableFacetModel object : this.i.values()) {
            if (!object.isModified()) continue;
            return true;
        }
        for (FacetEditorImpl facetEditorImpl : this.c.values()) {
            if (!facetEditorImpl.isModified()) continue;
            return true;
        }
        return false;
    }

    public FacetTreeModel getTreeModel(Module module2) {
        FacetTreeModel facetTreeModel = this.l.get(module2);
        if (facetTreeModel == null) {
            facetTreeModel = new FacetTreeModel();
            this.l.put(module2, facetTreeModel);
        }
        return facetTreeModel;
    }

    public FacetInfo getFacetInfo(Facet facet) {
        return this.f.get(facet);
    }

    public Facet getFacet(FacetInfo facetInfo) {
        return this.k.get(facetInfo);
    }

    public void disposeEditors() {
        for (Facet object : this.g) {
            Disposer.dispose((Disposable)object);
        }
        this.g.clear();
        this.j.clear();
        for (FacetEditorImpl facetEditorImpl : this.c.values()) {
            facetEditorImpl.disposeUIResources();
        }
        this.b = null;
    }

    @NotNull
    public Facet[] getAllFacets(Module module2) {
        Facet[] facetArray = this.getFacetModel(module2).getAllFacets();
        if (facetArray == null) {
            ProjectFacetsConfigurator.a(5);
        }
        return facetArray;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(Module module2, FacetTypeId<F> facetTypeId) {
        Collection collection = this.getFacetModel(module2).getFacetsByType(facetTypeId);
        if (collection == null) {
            ProjectFacetsConfigurator.a(6);
        }
        return collection;
    }

    @Nullable
    public <F extends Facet> F findFacet(Module module2, FacetTypeId<F> facetTypeId, String string) {
        return (F)this.getFacetModel(module2).findFacet(facetTypeId, string);
    }

    private UserDataHolder a() {
        if (this.b == null) {
            this.b = new UserDataHolderBase();
        }
        return this.b;
    }

    public String getFacetName(Facet facet) {
        String string;
        ModifiableFacetModel modifiableFacetModel = this.i.get(facet.getModule());
        if (modifiableFacetModel != null && (string = modifiableFacetModel.getNewName(facet)) != null) {
            return string;
        }
        return facet.getName();
    }

    public List<Facet> removeAllFacets(Module module2) {
        ArrayList<Facet> arrayList = new ArrayList<Facet>();
        ModifiableFacetModel modifiableFacetModel = this.getOrCreateModifiableModel(module2);
        for (Facet facet : modifiableFacetModel.getAllFacets()) {
            if (!this.j.contains(facet)) {
                this.g.add(facet);
            }
            a.assertTrue(facet.getModule().equals(module2), (Object)(module2 + " expected but " + facet.getModule() + " found"));
            arrayList.addAll(this.removeFacet(facet));
        }
        this.h.remove(module2);
        this.i.remove(module2);
        return arrayList;
    }

    public boolean hasFacetOfType(Module module2, @Nullable Facet facet, FacetTypeId<?> facetTypeId) {
        FacetTreeModel facetTreeModel = this.getTreeModel(module2);
        FacetInfo facetInfo = this.getFacetInfo(facet);
        return facetTreeModel.hasFacetOfType(facetInfo, facetTypeId);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ProjectFacetsConfigurator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModifiableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ProjectFacetsConfigurator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProjectConfigurableContext
    extends ProjectConfigurableContext {
        private final LibrariesContainer j;

        public MyProjectConfigurableContext(Facet facet, FacetEditorContext facetEditorContext, ModuleConfigurationState moduleConfigurationState) {
            super(facet, ProjectFacetsConfigurator.this.a(facet), facetEditorContext, moduleConfigurationState, ProjectFacetsConfigurator.this.a(facet.getModule()), ProjectFacetsConfigurator.this.a());
            this.j = LibrariesContainerFactory.createContainer(ProjectFacetsConfigurator.this.d);
        }

        @Override
        public LibrariesContainer getContainer() {
            return this.j;
        }
    }
}

