/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.DetectedRootsChooser;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RootsDetectionStep
extends AbstractStepWithProgress<List<DetectedRootData>> {
    private static final String n = "roots_found";
    private static final String l = "roots_not_found";
    private final ProjectFromSourcesBuilderImpl m;
    private final WizardContext i;
    private final StepSequence j;
    private final Icon o;
    private final String q;
    private DetectedRootsChooser k;
    private String r = null;
    private JPanel p;

    public RootsDetectionStep(ProjectFromSourcesBuilderImpl projectFromSourcesBuilderImpl, WizardContext wizardContext, StepSequence stepSequence, Icon icon, @NonNls String string) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.m = projectFromSourcesBuilderImpl;
        this.i = wizardContext;
        this.j = stepSequence;
        this.o = icon;
        this.q = string;
    }

    @Override
    protected JComponent createResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.k = new DetectedRootsChooser();
        this.k.addSelectionListener(new DetectedRootsChooser.RootSelectionListener(){

            @Override
            public void selectionChanged() {
                RootsDetectionStep.this.c();
            }
        });
        String string = IdeBundle.message((String)"label.project.roots.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.k.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.k.setAllElementsMarked(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.k.setAllElementsMarked(false);
            }
        });
        this.p = new JPanel(new CardLayout());
        this.p.add(n, jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(JBUI.Borders.empty((int)5));
        jPanel2.add("North", (Component)new MultiLineLabel(IdeBundle.message((String)"label.project.roots.not.found", (Object[])new Object[0])));
        this.p.add(l, jPanel2);
        return this.p;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.k.getComponent();
    }

    public void updateDataModel() {
        List<DetectedRootData> list2 = this.k.getMarkedElements();
        this.m.setupProjectStructure(RootDetectionProcessor.createRootsMap(list2));
        this.c();
    }

    private void c() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("Existing Sources");
        for (DetectedRootData detectedRootData : this.k.getMarkedElements()) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                linkedHashSet.add(projectStructureDetector.getDetectorId());
            }
        }
        this.j.setTypes(linkedHashSet);
        this.i.requestWizardButtonsUpdate();
    }

    @Override
    protected boolean shouldRunProgress() {
        String string = this.a();
        return this.r == null ? string != null : !this.r.equals(string);
    }

    @Override
    protected void onFinished(List<DetectedRootData> list2, boolean bl2) {
        CardLayout cardLayout = (CardLayout)this.p.getLayout();
        if (list2.size() > 0 && !bl2) {
            this.r = this.a();
            this.k.setElements(list2);
            this.c();
            cardLayout.show(this.p, n);
        } else {
            this.r = null;
            cardLayout.show(this.p, l);
        }
        this.p.revalidate();
    }

    @Override
    protected List<DetectedRootData> calculate() {
        String string = this.a();
        if (string == null) {
            return Collections.emptyList();
        }
        return RootDetectionProcessor.detectRoots(new File(string));
    }

    @Nullable
    private String a() {
        return this.m.getBaseProjectPath();
    }

    @Override
    protected String getProgressText() {
        String string = this.a();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.o;
    }

    public String getHelpId() {
        return this.q;
    }
}

