/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ProjectJdkStep
extends ModuleWizardStep {
    private final WizardContext a;
    private ProjectDescriptor c;
    protected final ProjectJdksConfigurable myProjectJdksConfigurable;
    private final JComponent b;

    public ProjectJdkStep(WizardContext wizardContext) {
        this.a = wizardContext;
        this.myProjectJdksConfigurable = new ProjectJdksConfigurable(ProjectManager.getInstance().getDefaultProject());
        this.myProjectJdksConfigurable.reset();
        this.b = this.myProjectJdksConfigurable.createComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.b;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.sdk";
    }

    public JComponent getComponent() {
        JLabel jLabel = new JLabel(IdeBundle.message((String)"prompt.please.select.project.jdk", (Object[])new Object[0]));
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        JPanel jPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(-1, 200);
            }
        };
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.b.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jPanel.add((Component)this.b, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return jPanel;
    }

    public void updateStep() {
        Sdk sdk = this.a.getProjectJdk();
        if (sdk == null) {
            JavaSdkVersion javaSdkVersion;
            JavaSdkVersion javaSdkVersion2 = javaSdkVersion = this.c != null ? this.c.getRequiredJdkVersion() : null;
            if (javaSdkVersion != null) {
                this.myProjectJdksConfigurable.selectJdkVersion(javaSdkVersion);
            }
        }
    }

    public void updateDataModel() {
        this.a.setProjectJdk(this.getJdk());
    }

    public Sdk getJdk() {
        return this.myProjectJdksConfigurable.getSelectedJdk();
    }

    public Icon getIcon() {
        return this.a.getStepIcon();
    }

    public boolean validate() throws ConfigurationException {
        int n2;
        Sdk sdk = this.myProjectJdksConfigurable.getSelectedJdk();
        if (sdk == null && !ApplicationManager.getApplication().isUnitTestMode() && (n2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return false;
        }
        this.myProjectJdksConfigurable.apply();
        return true;
    }

    public String getName() {
        return "Project JDK";
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myProjectJdksConfigurable.disposeUIResources();
    }

    public void setProjectDescriptor(ProjectDescriptor projectDescriptor) {
        this.c = projectDescriptor;
    }
}

